/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.config;

import cn.coufran.springboot.starter.api.Result;
import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.annotation.Public;
import cn.coufran.springboot.starter.auth.config.AuthAddition;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthInterceptor
implements HandlerInterceptor {
    private Collection<String> whitePaths = new HashSet<String>();
    private AuthUser authUser;
    private List<AuthAddition> authAdditions;

    public AuthInterceptor(AuthUser authUser) {
        this.authUser = authUser;
    }

    public void setWhitePaths(List<String> whitePaths) {
        this.whitePaths = whitePaths;
    }

    public void addWhitePath(String whitePath) {
        this.whitePaths.add(whitePath);
    }

    public void removeWhitePath(String whitePath) {
        this.whitePaths.remove(whitePath);
    }

    public void setAuthAdditions(List<AuthAddition> authAdditions) {
        this.authAdditions = authAdditions;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String servletPath;
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            return true;
        }
        if (this.whitePaths != null && !this.whitePaths.isEmpty() && this.whitePaths.contains(servletPath = request.getServletPath())) {
            return true;
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Public publicAnnotation = handlerMethod.getMethod().getAnnotation(Public.class);
            if (publicAnnotation != null) {
                return true;
            }
            publicAnnotation = handlerMethod.getBeanType().getAnnotation(Public.class);
            if (publicAnnotation != null) {
                return true;
            }
        }
        if (!this.authUser.isAuthenticated()) {
            this.writeResponse(response, HttpStatus.UNAUTHORIZED, 40101, "\u8bf7\u767b\u5f55");
            return false;
        }
        if (this.authAdditions != null) {
            for (AuthAddition authAddition : this.authAdditions) {
                try {
                    authAddition.authIntercept(this.authUser, request, handler);
                }
                catch (AuthAddition.AuthException e) {
                    HttpStatus status = e.getHttpStatus();
                    Result result = e.getResult();
                    this.writeResponse(response, status, result);
                    return false;
                }
            }
        }
        return true;
    }

    private void writeResponse(HttpServletResponse response, HttpStatus status, Result result) throws IOException {
        response.setStatus(status.value());
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        String responseBody = JSON.toJSONString((Object)result);
        writer.write(responseBody);
    }

    private void writeResponse(HttpServletResponse response, HttpStatus status, int code, String msg) throws IOException {
        this.writeResponse(response, status, Result.error((int)code, (String)msg));
    }
}

