/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth;

import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.Certificate;

public interface AuthUserManager {
    default public <D> AuthUser<D> getAuthUser(Certificate certificate) {
        if (certificate == null) {
            return this.createAnonymous();
        }
        AuthUser<D> authUser = this.reloadAuthenticated(certificate);
        if (authUser == null) {
            authUser = this.createAnonymous();
        }
        return authUser;
    }

    public <D> AuthUser<D> reloadAuthenticated(Certificate var1);

    public <D> AuthUser<D> createAnonymous();

    public <D> Certificate acceptLogin(AuthUser<D> var1, D var2);

    public <D> Certificate acceptRefresh(AuthUser<D> var1);

    public <U> void acceptLogout(AuthUser<U> var1);
}

