/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.api.config;

import cn.coufran.commons.Result;
import cn.coufran.commons.exception.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);
    private Collection<Class<? extends RuntimeException>> serviceExceptionClasses = new ArrayList<Class<? extends RuntimeException>>();

    @Autowired(required=false)
    public void setServiceExceptionClasses(Collection<Class<? extends RuntimeException>> serviceExceptionClasses) {
        this.serviceExceptionClasses.addAll(serviceExceptionClasses);
    }

    public void addServiceExceptionClass(Class<? extends RuntimeException> ... serviceExceptionClasses) {
        this.serviceExceptionClasses.addAll(Arrays.asList(serviceExceptionClasses));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Exception.class})
    public Result handlerException(Exception e) throws ServletException {
        if (e instanceof ServletException || e.getClass().getPackage().getName().startsWith("org.springframework.")) {
            throw (ServletException)e;
        }
        String message = "\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5";
        String code = null;
        if (this.isServiceException(e)) {
            message = e.getMessage();
            if (e instanceof ServiceException) {
                code = ((ServiceException)e).getCode();
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("{}", (Object)e.toString());
        }
        if (code == null) {
            code = "500";
        }
        return Result.error((String)code, (String)message);
    }

    private boolean isServiceException(Throwable e) {
        if (this.serviceExceptionClasses == null || this.serviceExceptionClasses.isEmpty()) {
            return false;
        }
        for (Class<? extends RuntimeException> serviceExceptionClass : this.serviceExceptionClasses) {
            if (!serviceExceptionClass.isInstance(e)) continue;
            return true;
        }
        return false;
    }
}

