package cn.coufran.springboot.starter.api.config;

import com.alibaba.fastjson2.support.config.FastJsonConfig;
import com.alibaba.fastjson2.support.spring.http.converter.FastJsonHttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * Spring Web MVC配置
 * @author Coufran
 * @since 2.0.0
 * @version 1.0.0
 */
public class SpringWebMvcConfig implements WebMvcConfigurer {
    /** FastJson配置 */
    @Resource
    private FastJsonConfig fastJsonConfig;

    /**
     * POM文件中移除了默认的Jackson依赖，手动配置Fastjson converter。
     * @param converters converter列表
     */
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        converter.setFastJsonConfig(fastJsonConfig);
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.APPLICATION_JSON));

        converters.add(0, converter);
    }
}
