package cn.coufran.springboot.starter.api.config;

import cn.coufran.springboot.starter.json.HibernateValueFilter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * Fastjson配置
 * @author Coufran
 * @version 2.0.0
 * @since 1.0.0
 */
public class JsonConfig {
    /**
     * 默认Fastjson配置
     * @param hibernateValueFilter hibernateValueFilter
     * @return Fastjson配置
     */
    @Bean
    @ConditionalOnMissingBean(FastJsonConfig.class)
    public FastJsonConfig fastJsonConfig(HibernateValueFilter hibernateValueFilter) {
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setWriterFilters(hibernateValueFilter); // 添加Hibernate过滤器
        return fastJsonConfig;
    }
}
