package cn.coufran.springboot.starter.api;

import cn.coufran.commons.exception.ServiceException;
import cn.coufran.springboot.starter.api.config.JsonConfig;
import cn.coufran.springboot.starter.api.config.ResponseHandler;
import cn.coufran.springboot.starter.api.config.ExceptionHandler;
import cn.coufran.springboot.starter.api.config.SpringWebMvcConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.ArrayList;
import java.util.Collection;

/**
 * 配置类
 * @author Coufran
 * @version 1.3.0
 * @since 1.3.0
 */
@Configuration
@Import({
        ExceptionHandler.class,
        ResponseHandler.class,
        JsonConfig.class,
        SpringWebMvcConfig.class
})
public class Config {
    /**
     * 配置默认的业务异常类
     * @return 业务异常类
     */
    @Bean
    @ConditionalOnMissingBean
    public Collection<Class<? extends RuntimeException>> serviceExceptionClasses() {
        Collection<Class<? extends RuntimeException>> list = new ArrayList<>();
        list.add(ServiceException.class);
        return list;
    }
}
