/*
 * Decompiled with CFR 0.152.
 */
package com.assetcloud.message.center.support;

import com.assetcloud.message.center.core.CloudMessageLocalTransactionListener;
import com.assetcloud.message.center.core.CloudMessageLocalTransactionState;
import com.assetcloud.message.center.entity.CloudMessage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CloudMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(CloudMessageUtil.class);

    public static TransactionListener convert(final CloudMessageLocalTransactionListener listener) {
        return new TransactionListener(){

            public LocalTransactionState executeLocalTransaction(Message message, Object obj) {
                CloudMessageLocalTransactionState state = listener.executeLocalTransaction(CloudMessageUtil.convertToSpringMessage(message), obj);
                return CloudMessageUtil.convertLocalTransactionState(state);
            }

            public LocalTransactionState checkLocalTransaction(MessageExt cloudMessage) {
                CloudMessageLocalTransactionState state = listener.checkLocalTransaction(CloudMessageUtil.convertToSpringMessage((Message)cloudMessage));
                return CloudMessageUtil.convertLocalTransactionState(state);
            }
        };
    }

    private static LocalTransactionState convertLocalTransactionState(CloudMessageLocalTransactionState state) {
        switch (state) {
            case UNKNOWN: {
                return LocalTransactionState.UNKNOW;
            }
            case COMMIT: {
                return LocalTransactionState.COMMIT_MESSAGE;
            }
            case ROLLBACK: {
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
        }
        log.warn("Failed to covert enum type RocketMQLocalTransactionState.%s", (Object)state);
        return LocalTransactionState.UNKNOW;
    }

    public static MessagingException convert(MQClientException e) {
        return new MessagingException(e.getErrorMessage(), (Throwable)e);
    }

    public static org.springframework.messaging.Message convertToSpringMessage(CloudMessage message) {
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message.getBody()).setHeader(CloudMessageUtil.toRocketHeaderKey("KEYS"), (Object)message.getKeys()).setHeader(CloudMessageUtil.toRocketHeaderKey("TAGS"), (Object)message.getTags()).setHeader(CloudMessageUtil.toRocketHeaderKey("TOPIC"), (Object)message.getTopic()).setHeader(CloudMessageUtil.toRocketHeaderKey("MESSAGE_ID"), (Object)message.getMsgId()).setHeader(CloudMessageUtil.toRocketHeaderKey("BORN_TIMESTAMP"), (Object)message.getBornTimestamp()).setHeader(CloudMessageUtil.toRocketHeaderKey("BORN_HOST"), (Object)message.getBornHostString()).setHeader(CloudMessageUtil.toRocketHeaderKey("FLAG"), (Object)message.getFlag()).setHeader(CloudMessageUtil.toRocketHeaderKey("QUEUE_ID"), (Object)message.getQueueId()).setHeader(CloudMessageUtil.toRocketHeaderKey("SYS_FLAG"), (Object)message.getSysFlag()).setHeader(CloudMessageUtil.toRocketHeaderKey("TRANSACTION_ID"), (Object)message.getTransactionId());
        CloudMessageUtil.addUserProperties(message.getProperties(), messageBuilder);
        return messageBuilder.build();
    }

    public static String toRocketHeaderKey(String rawKey) {
        return "cloudmessage_" + rawKey;
    }

    private static void addUserProperties(Map<String, String> properties, MessageBuilder messageBuilder) {
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach((key, val) -> {
                if (!(MessageConst.STRING_HASH_SET.contains(key) || "id".equals(key) || "timestamp".equals(key))) {
                    messageBuilder.setHeader(key, val);
                }
            });
        }
    }

    public static org.springframework.messaging.Message convertToSpringMessage(Message message) {
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message.getBody()).setHeader(CloudMessageUtil.toRocketHeaderKey("KEYS"), (Object)message.getKeys()).setHeader(CloudMessageUtil.toRocketHeaderKey("TAGS"), (Object)message.getTags()).setHeader(CloudMessageUtil.toRocketHeaderKey("TOPIC"), (Object)message.getTopic()).setHeader(CloudMessageUtil.toRocketHeaderKey("FLAG"), (Object)message.getFlag()).setHeader(CloudMessageUtil.toRocketHeaderKey("TRANSACTION_ID"), (Object)message.getTransactionId());
        CloudMessageUtil.addUserProperties(message.getProperties(), messageBuilder);
        return messageBuilder.build();
    }

    public static Message convertToRocketMessage(ObjectMapper objectMapper, String charset, String destination, org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        Object payloadObj = message.getPayload();
        if (payloadObj instanceof String) {
            payloads = ((String)payloadObj).getBytes(Charset.forName(charset));
        } else if (payloadObj instanceof byte[]) {
            payloads = (byte[])message.getPayload();
        } else {
            try {
                String jsonObj = objectMapper.writeValueAsString(payloadObj);
                payloads = jsonObj.getBytes(Charset.forName(charset));
            }
            catch (Exception e) {
                throw new RuntimeException("convert to RocketMQ message failed.", e);
            }
        }
        String[] tempArr = destination.split(":", 2);
        String topic = tempArr[0];
        String tags = "";
        if (tempArr.length > 1) {
            tags = tempArr[1];
        }
        Message rocketMsg = new Message(topic, tags, payloads);
        MessageHeaders headers = message.getHeaders();
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            Object keys = headers.get((Object)"KEYS");
            if (!StringUtils.isEmpty((Object)keys)) {
                rocketMsg.setKeys(keys.toString());
            }
            Object flagObj = headers.getOrDefault((Object)"FLAG", (Object)"0");
            int flag = 0;
            try {
                flag = Integer.parseInt(flagObj.toString());
            }
            catch (NumberFormatException e) {
                log.info("flag must be integer, flagObj:{}", flagObj);
            }
            rocketMsg.setFlag(flag);
            Object waitStoreMsgOkObj = headers.getOrDefault((Object)"WAIT_STORE_MSG_OK", (Object)"true");
            boolean waitStoreMsgOK = Boolean.TRUE.equals(waitStoreMsgOkObj);
            rocketMsg.setWaitStoreMsgOK(waitStoreMsgOK);
            headers.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "FLAG") && !Objects.equals(entry.getKey(), "WAIT_STORE_MSG_OK")).forEach(entry -> {
                if (!MessageConst.STRING_HASH_SET.contains(entry.getKey())) {
                    rocketMsg.putUserProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            });
        }
        return rocketMsg;
    }

    public static RPCHook getRPCHookByAkSk(Environment env, String accessKeyOrExpr, String secretKeyOrExpr) {
        String sk;
        String ak;
        try {
            ak = env.resolveRequiredPlaceholders(accessKeyOrExpr);
            sk = env.resolveRequiredPlaceholders(secretKeyOrExpr);
        }
        catch (Exception e) {
            ak = null;
            sk = null;
        }
        if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
            return new AclClientRPCHook(new SessionCredentials(ak, sk));
        }
        return null;
    }

    public static String getInstanceName(RPCHook rpcHook, String identify) {
        String separator = "|";
        StringBuilder instanceName = new StringBuilder();
        SessionCredentials sessionCredentials = ((AclClientRPCHook)rpcHook).getSessionCredentials();
        instanceName.append(sessionCredentials.getAccessKey()).append(separator).append(sessionCredentials.getSecretKey()).append(separator).append(identify);
        return instanceName.toString();
    }
}

