/*
 * Decompiled with CFR 0.152.
 */
package com.assetcloud.message.center.config;

import com.assetcloud.message.center.config.TransactionHandler;
import com.assetcloud.message.center.core.CloudMessageTemplate;
import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import org.apache.rocketmq.client.exception.MQClientException;
import org.springframework.beans.factory.DisposableBean;

public class TransactionHandlerRegistry
implements DisposableBean {
    private CloudMessageTemplate cloudMessageTemplate;
    private final Set<String> listenerContainers = new ConcurrentSet();

    public TransactionHandlerRegistry(CloudMessageTemplate template) {
        this.cloudMessageTemplate = template;
    }

    public void destroy() throws Exception {
        this.listenerContainers.clear();
    }

    public void registerTransactionHandler(TransactionHandler handler) throws MQClientException {
        if (this.listenerContainers.contains(handler.getName())) {
            throw new MQClientException(-1, String.format("The transaction name [%s] has been defined in TransactionListener [%s]", handler.getName(), handler.getBeanName()));
        }
        this.listenerContainers.add(handler.getName());
        this.cloudMessageTemplate.createAndStartTransactionMQProducer(handler.getName(), handler.getListener(), handler.getCheckExecutor(), handler.getRpcHook());
    }
}

