/*
 * Decompiled with CFR 0.152.
 */
package com.assetcloud.message.center.config;

import com.assetcloud.message.center.annotation.EnableCloudMessageTransactionListener;
import com.assetcloud.message.center.config.TransactionHandler;
import com.assetcloud.message.center.config.TransactionHandlerRegistry;
import com.assetcloud.message.center.core.CloudMessageLocalTransactionListener;
import com.assetcloud.message.center.support.CloudMessageUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class CloudMessageTransactionAnnotationProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CloudMessageTransactionAnnotationProcessor.class);
    private ApplicationContext applicationContext;
    private final Set<Class<?>> nonProcessedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private TransactionHandlerRegistry transactionHandlerRegistry;

    public CloudMessageTransactionAnnotationProcessor(TransactionHandlerRegistry transactionHandlerRegistry) {
        this.transactionHandlerRegistry = transactionHandlerRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonProcessedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            EnableCloudMessageTransactionListener listener = (EnableCloudMessageTransactionListener)AnnotationUtils.findAnnotation((Class)targetClass, EnableCloudMessageTransactionListener.class);
            this.nonProcessedClasses.add(bean.getClass());
            if (listener == null) {
                log.trace("No @RocketMQTransactionListener annotations found on bean type: {}", bean.getClass());
            } else {
                try {
                    this.processTransactionListenerAnnotation(listener, bean);
                }
                catch (MQClientException e) {
                    log.error("Failed to process annotation " + listener, (Throwable)e);
                    throw new BeanCreationException("Failed to process annotation " + listener, (Throwable)e);
                }
            }
        }
        return bean;
    }

    private void processTransactionListenerAnnotation(EnableCloudMessageTransactionListener listener, Object bean) throws MQClientException {
        if (this.transactionHandlerRegistry == null) {
            throw new MQClientException("Bad usage of @RocketMQTransactionListener, the class must work with RocketMQTemplate", null);
        }
        if (!CloudMessageLocalTransactionListener.class.isAssignableFrom(bean.getClass())) {
            throw new MQClientException("Bad usage of @RocketMQTransactionListener, the class must implement interface RocketMQLocalTransactionListener", null);
        }
        TransactionHandler transactionHandler = new TransactionHandler();
        transactionHandler.setBeanFactory((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
        transactionHandler.setName(listener.txProducerGroup());
        transactionHandler.setBeanName(bean.getClass().getName());
        transactionHandler.setListener((CloudMessageLocalTransactionListener)bean);
        transactionHandler.setCheckExecutor(listener.corePoolSize(), listener.maximumPoolSize(), listener.keepAliveTime(), listener.blockingQueueSize());
        RPCHook rpcHook = CloudMessageUtil.getRPCHookByAkSk(this.applicationContext.getEnvironment(), listener.accessKey(), listener.secretKey());
        if (Objects.nonNull(rpcHook)) {
            transactionHandler.setRpcHook(rpcHook);
        } else {
            log.debug("Access-key or secret-key not configure in " + listener + ".");
        }
        this.transactionHandlerRegistry.registerTransactionHandler(transactionHandler);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

