/*
 * Decompiled with CFR 0.152.
 */
package com.assetcloud.message.center.autoconfigure;

import com.assetcloud.message.center.annotation.ConsumeMode;
import com.assetcloud.message.center.annotation.EnableCloudMessageListener;
import com.assetcloud.message.center.annotation.MessageModel;
import com.assetcloud.message.center.autoconfigure.CloudMessageProperties;
import com.assetcloud.message.center.core.CloudMessageListener;
import com.assetcloud.message.center.support.DefaultCloudMessageListenerContainer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.AccessChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@Configuration
public class ListenerContainerConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private AtomicLong counter = new AtomicLong(0L);
    private StandardEnvironment environment;
    private CloudMessageProperties cloudMessageProperties;
    private ObjectMapper objectMapper;

    public ListenerContainerConfiguration(ObjectMapper rocketMQMessageObjectMapper, StandardEnvironment environment, CloudMessageProperties cloudMessageProperties) {
        this.objectMapper = rocketMQMessageObjectMapper;
        this.environment = environment;
        this.cloudMessageProperties = cloudMessageProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map beans = this.applicationContext.getBeansWithAnnotation(EnableCloudMessageListener.class);
        if (Objects.nonNull(beans)) {
            beans.forEach(this::registerContainer);
        }
    }

    private void registerContainer(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!CloudMessageListener.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + CloudMessageListener.class.getName());
        }
        EnableCloudMessageListener annotation = clazz.getAnnotation(EnableCloudMessageListener.class);
        this.validate(annotation);
        String containerBeanName = String.format("%s_%s", DefaultCloudMessageListenerContainer.class.getName(), this.counter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, DefaultCloudMessageListenerContainer.class, () -> this.createRocketMQListenerContainer(containerBeanName, bean, annotation), new BeanDefinitionCustomizer[0]);
        DefaultCloudMessageListenerContainer container = (DefaultCloudMessageListenerContainer)genericApplicationContext.getBean(containerBeanName, DefaultCloudMessageListenerContainer.class);
        if (!container.isRunning()) {
            try {
                container.start();
            }
            catch (Exception e) {
                log.error("Started container failed. {}", (Object)container, (Object)e);
                throw new RuntimeException(e);
            }
        }
        log.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    private DefaultCloudMessageListenerContainer createRocketMQListenerContainer(String name, Object bean, EnableCloudMessageListener annotation) {
        DefaultCloudMessageListenerContainer container = new DefaultCloudMessageListenerContainer();
        String nameServer = this.environment.resolvePlaceholders(annotation.nameServer());
        nameServer = StringUtils.isEmpty((Object)nameServer) ? this.cloudMessageProperties.getNameServer() : nameServer;
        String accessChannel = this.environment.resolvePlaceholders(annotation.accessChannel());
        container.setNameServer(nameServer);
        if (!StringUtils.isEmpty((Object)accessChannel)) {
            container.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        container.setTopic(this.environment.resolvePlaceholders(annotation.topic()));
        container.setConsumerGroup(this.environment.resolvePlaceholders(annotation.consumerGroup()));
        container.setRocketMQMessageListener(annotation);
        container.setCloudMessageListener((CloudMessageListener)bean);
        container.setObjectMapper(this.objectMapper);
        container.setName(name);
        return container;
    }

    private void validate(EnableCloudMessageListener annotation) {
        if (annotation.consumeMode() == ConsumeMode.ORDERLY && annotation.messageModel() == MessageModel.BROADCASTING) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @RocketMQMessageListener, messageModel BROADCASTING does not support ORDERLY message!");
        }
    }
}

