/*
 * Decompiled with CFR 0.152.
 */
package com.assetcloud.message.center.autoconfigure;

import com.assetcloud.message.center.autoconfigure.CloudMessageProperties;
import com.assetcloud.message.center.autoconfigure.ExtProducerResetConfiguration;
import com.assetcloud.message.center.autoconfigure.JacksonFallbackConfiguration;
import com.assetcloud.message.center.autoconfigure.ListenerContainerConfiguration;
import com.assetcloud.message.center.config.CloudMessageTransactionAnnotationProcessor;
import com.assetcloud.message.center.config.TransactionHandlerRegistry;
import com.assetcloud.message.center.core.CloudMessageTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.MQAdmin;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CloudMessageProperties.class})
@ConditionalOnClass(value={MQAdmin.class, ObjectMapper.class})
@ConditionalOnProperty(prefix="cloudmessage", value={"name-server"}, matchIfMissing=true)
@Import(value={JacksonFallbackConfiguration.class, ListenerContainerConfiguration.class, ExtProducerResetConfiguration.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class CloudMessageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CloudMessageAutoConfiguration.class);
    @Autowired
    private Environment environment;

    @PostConstruct
    public void checkProperties() {
        String nameServer = (String)this.environment.getProperty("cloudmessage.name-server", String.class);
        log.debug("cloudmessage.nameServer = {}", (Object)nameServer);
        if (nameServer == null) {
            log.warn("The necessary spring property 'rocketmq.name-server' is not defined, all rockertmq beans creation are skipped!");
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultMQProducer.class})
    @ConditionalOnProperty(prefix="cloudmessage", value={"name-server", "producer.group"})
    public DefaultMQProducer defaultMQProducer(CloudMessageProperties cloudMessageProperties) {
        DefaultMQProducer producer;
        CloudMessageProperties.Producer producerConfig = cloudMessageProperties.getProducer();
        String nameServer = cloudMessageProperties.getNameServer();
        String groupName = producerConfig.getGroup();
        Assert.hasText((String)nameServer, (String)"[rocketmq.name-server] must not be null");
        Assert.hasText((String)groupName, (String)"[rocketmq.producer.group] must not be null");
        String accessChannel = cloudMessageProperties.getAccessChannel();
        String ak = cloudMessageProperties.getProducer().getAccessKey();
        String sk = cloudMessageProperties.getProducer().getSecretKey();
        if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
            producer = new DefaultMQProducer(groupName, (RPCHook)new AclClientRPCHook(new SessionCredentials(ak, sk)), cloudMessageProperties.getProducer().isEnableMsgTrace(), cloudMessageProperties.getProducer().getCustomizedTraceTopic());
            producer.setVipChannelEnabled(false);
        } else {
            producer = new DefaultMQProducer(groupName, cloudMessageProperties.getProducer().isEnableMsgTrace(), cloudMessageProperties.getProducer().getCustomizedTraceTopic());
        }
        producer.setNamesrvAddr(nameServer);
        if (!StringUtils.isEmpty((Object)accessChannel)) {
            producer.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        producer.setSendMsgTimeout(producerConfig.getSendMessageTimeout());
        producer.setRetryTimesWhenSendFailed(producerConfig.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerConfig.getRetryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(producerConfig.getMaxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(producerConfig.getCompressMessageBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerConfig.isRetryNextServer());
        return producer;
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnBean(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"cloudmessageTemplate"})
    public CloudMessageTemplate rocketMQTemplate(DefaultMQProducer mqProducer, ObjectMapper rocketMQMessageObjectMapper) {
        CloudMessageTemplate cloudMessageTemplate = new CloudMessageTemplate();
        cloudMessageTemplate.setProducer(mqProducer);
        cloudMessageTemplate.setObjectMapper(rocketMQMessageObjectMapper);
        return cloudMessageTemplate;
    }

    @Bean
    @ConditionalOnBean(name={"cloudmessageTemplate"})
    @ConditionalOnMissingBean(value={TransactionHandlerRegistry.class})
    public TransactionHandlerRegistry transactionHandlerRegistry(@Qualifier(value="cloudmessageTemplate") CloudMessageTemplate template) {
        return new TransactionHandlerRegistry(template);
    }

    @Bean(name={"org.springframework.rocketmq.spring.starter.internalRocketMQTransAnnotationProcessor"})
    @ConditionalOnBean(value={TransactionHandlerRegistry.class})
    @Role(value=2)
    public static CloudMessageTransactionAnnotationProcessor transactionAnnotationProcessor(TransactionHandlerRegistry transactionHandlerRegistry) {
        return new CloudMessageTransactionAnnotationProcessor(transactionHandlerRegistry);
    }
}

