/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.sql.SQLException;

public class PGobject
implements Serializable,
Cloneable {
    protected String type;
    protected String value;
    protected Object[] struct;
    private String[] arrayValue;

    public void setArrayValue(String[] arrayValue) {
        this.arrayValue = arrayValue;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) throws SQLException {
        this.value = value;
    }

    public final String getType() {
        return this.type;
    }

    public String getValue() {
        if (this.value == null && this.arrayValue != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (String v : this.arrayValue) {
                v = v.replace(",", "\\,").replace("(", "\\(").replace(")", "\\)");
                sb.append(v).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }
        return this.value;
    }

    public final void setStruct(Object[] struct) {
        this.struct = struct;
    }

    public final Object[] getStruct() {
        return this.struct;
    }

    public String[] getArrayValue() {
        if (this.arrayValue != null) {
            return this.arrayValue;
        }
        if (this.struct != null && this.struct.length > 0 && this.value.length() > 2) {
            this.arrayValue = new String[this.struct.length];
            char[] chars = this.value.toCharArray();
            int noBeginAndEndBracketLen = chars.length - 1;
            int begin = 1;
            int end = 1;
            int index = 0;
            block0: for (int i = 1; i < noBeginAndEndBracketLen; ++i) {
                if (chars[i] == '\"') {
                    while (i + 2 <= noBeginAndEndBracketLen) {
                        if (chars[i + 1] == '\"') {
                            if (i + 2 == noBeginAndEndBracketLen || chars[i + 2] == ',') {
                                end = i += 2;
                                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, end, this.value);
                                ++index;
                                begin = end + 1;
                                continue block0;
                            }
                            if (chars[i + 2] != '\"') {
                                this.arrayValue = new String[]{this.value};
                                return new String[]{this.value};
                            }
                            i += 2;
                            continue;
                        }
                        ++i;
                    }
                    continue;
                }
                if (chars[i] != ',') continue;
                end = i;
                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, end, this.value);
                ++index;
                begin = end + 1;
            }
            if (end != noBeginAndEndBracketLen) {
                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, noBeginAndEndBracketLen, this.value);
            }
        } else {
            this.arrayValue = new String[]{this.value};
        }
        return this.arrayValue;
    }

    private String delimitedCompositeTypeValue(int begin, int end, String originalChar) {
        String attribute = originalChar.substring(begin, end);
        return attribute != null && attribute.length() > 0 ? attribute : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGobject) {
            String otherValue = ((PGobject)obj).getValue();
            if (otherValue == null) {
                return this.getValue() == null;
            }
            return otherValue.equals(this.getValue());
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

