/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.DbCompatibility;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TypeInfoCache
implements TypeInfo {
    private final Map<String, Integer> _pgNameToSQLType;
    private final Map<String, String> _pgNameToJavaClass;
    private final Map<Integer, String> _oidToPgName;
    private final Map<String, Integer> _pgNameToOid;
    private final Map<String, Class<? extends PGobject>> _pgNameToPgObject;
    private final Map<Integer, Integer> _pgArrayToPgType;
    private final Map<Integer, Character> _arrayOidToDelimiter;
    private final BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatementSimple;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private static final Object[][] types = new Object[][]{{"int1", 5545, -6, "java.lang.Integer", 5546}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"smalldatetime", 9003, 93, "java.lang.Timestamp", 9005}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"json", 114, 1111, "org.postgresql.util.PGobject", 199}, {"point", 600, 1111, "org.postgresql.geometric.PGpoint", 1017}, {"nvarchar2", 3969, 12, "java.lang.String", 3968}, {"blob", 88, 2004, "org.postgresql.core.types.PGBlob", 3201}, {"clob", 90, 2005, "org.postgresql.core.types.PGClob", 3202}, {"rowid", 7301, -8, "org.postgresql.core.types.ROWID", 7302}, {"binary", 9779, -2, "[B", 0}, {"oradate", 9040, 93, "java.sql.Timestamp", 9073}, {"jsonb", 3802, 1111, "org.postgresql.util.PGobject", 3807}, {"raw", 86, -2, "[B", 87}, {"jsonpath", 4072, 12, "java.lang.String", 4073}, {"long", 93, 12, "java.lang.String", 0}, {"long_raw", 94, -2, "[B", 0}, {"sql_variant", 96, 1111, "org.postgresql.util.PGobject", 0}, {"varbinary", 95, -3, "[B", 0}, {"datetime2", 5950, 93, "java.sql.Timestamp", 5951}, {"mssql_datetime", 9008, 93, "java.sql.Timestamp", 9009}, {"image", 97, -4, "[B", 0}, {"number", 1399, 2, "java.math.BigDecimal", 1232}};
    private static final HashMap<String, String> typeAliases = new HashMap();
    private static final ConcurrentHashMap<Integer, Integer> pricisionToInteger;
    private static final ConcurrentHashMap<Integer, Integer> oidToInteger;

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap<Integer, String>();
        this._pgNameToOid = new HashMap<String, Integer>();
        this._pgNameToJavaClass = new HashMap<String, String>();
        this._pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>();
        this._pgArrayToPgType = new HashMap<Integer, Integer>();
        this._arrayOidToDelimiter = new HashMap<Integer, Character>();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, 2003);
        this._pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this._pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this._pgNameToSQLType.put(pgArrayTypeName, 2003);
            this._pgNameToOid.put(pgArrayTypeName, arrayOid);
            this._oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        if (this._getTypeInfoStatement == null) {
            String sql = "SELECT typinput='array_in'::regproc, typtype FROM ";
            sql = sql + "pg_catalog.";
            sql = sql + "pg_type WHERE typname = ?";
            this._getTypeInfoStatement = this._conn.prepareStatement(sql);
        }
        this._getTypeInfoStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        this._pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        if (this._getOidStatementSimple == null) {
            String sql = "SELECT oid, typname FROM pg_catalog.pg_type WHERE typname = ?";
            this._getOidStatementSimple = this._conn.prepareStatement(sql);
        }
        this._getOidStatementSimple.setString(1, pgTypeName);
        return this._getOidStatementSimple;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this._oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this._pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this._pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this._pgNameToOid.put(pgTypeName, oid);
            this._oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        int pgType = 0;
        for (String newTypeName : new String[]{TypeInfoCache.combainStringIfOneQuoted("_", elementTypeName), TypeInfoCache.combainStringIfOneQuoted(elementTypeName, "[]")}) {
            pgType = this.getPGType(newTypeName);
            if (pgType == 0) continue;
            return pgType;
        }
        return pgType;
    }

    private static String combainStringIfOneQuoted(String first, String second) {
        if (first.startsWith("\"")) {
            return first.substring(0, first.length() - 1) + second + "\"";
        }
        if (second.startsWith("\"")) {
            return "\"" + first + second.substring(1);
        }
        return first + second;
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this._pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this._arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this._arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this._pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this._pgArrayToPgType.put(oid, pgType);
        this._pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this._pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this._oidToPgName.put(pgType, name);
            this._pgNameToOid.put(name, pgType);
        } else {
            this._oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this._pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName;
        String result;
        if (DbCompatibility.ORACLE == this._conn.getDbCompatibility()) {
            switch (this.getSQLType(oid)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return "java.math.BigDecimal";
                }
            }
        }
        if ((result = this._pgNameToJavaClass.get(pgTypeName = this.getPGType(oid))) != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        if (pricisionToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return pricisionToInteger.get(oid);
        }
        switch (oid) {
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 9003: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: 
            case 5545: 
            case 9003: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    private int getValueOfTime(int oid, int typmod) {
        int secondSize;
        switch (typmod) {
            case -1: {
                secondSize = 7;
                break;
            }
            case 0: {
                secondSize = 0;
                break;
            }
            case 1: {
                secondSize = 3;
                break;
            }
            default: {
                secondSize = typmod + 1;
            }
        }
        switch (oid) {
            case 1083: {
                return 8 + secondSize;
            }
            case 1266: {
                return 8 + secondSize + 6;
            }
            case 9003: {
                return 22;
            }
            case 1114: {
                return 22 + secondSize;
            }
        }
        return 22 + secondSize + 6;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        if (oidToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return oidToInteger.get(oid);
        }
        switch (oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 9003: {
                return this.getValueOfTime(oid, typmod);
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this._unknownLength;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: 
            case 9003: {
                return 6;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static {
        typeAliases.put("tinyint", "int1");
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
        pricisionToInteger = new ConcurrentHashMap();
        pricisionToInteger.put(5545, 3);
        pricisionToInteger.put(21, 5);
        pricisionToInteger.put(26, 10);
        pricisionToInteger.put(23, 10);
        pricisionToInteger.put(20, 19);
        pricisionToInteger.put(700, 8);
        pricisionToInteger.put(701, 17);
        pricisionToInteger.put(18, 1);
        pricisionToInteger.put(16, 1);
        oidToInteger = new ConcurrentHashMap();
        oidToInteger.put(5545, 3);
        oidToInteger.put(21, 6);
        oidToInteger.put(23, 11);
        oidToInteger.put(26, 10);
        oidToInteger.put(20, 20);
        oidToInteger.put(700, 15);
        oidToInteger.put(701, 25);
        oidToInteger.put(18, 1);
        oidToInteger.put(16, 1);
        oidToInteger.put(1082, 13);
        oidToInteger.put(1186, 49);
    }
}

