/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PgCallstatementTypeCompatibility {
    private static TypeConvert noneConvert = new TypeConvert(){

        @Override
        public Object convert(Object input) {
            return input;
        }

        @Override
        public boolean needConvert() {
            return false;
        }
    };
    private static TypeConvert stringConvert = new TypeConvert(){

        @Override
        public Object convert(Object input) {
            return input.toString();
        }

        @Override
        public boolean needConvert() {
            return true;
        }
    };
    private static TypeConvert double2FloatConvert = new TypeConvert(){

        @Override
        public Object convert(Object input) {
            return Float.valueOf(((Double)input).floatValue());
        }

        @Override
        public boolean needConvert() {
            return true;
        }
    };
    private static TypeConvert numeric2integer = new TypeConvert(){

        @Override
        public Object convert(Object input) {
            String str = input.toString();
            int idx = str.lastIndexOf(".");
            if (idx > 0) {
                String strNum = str.substring(0, idx);
                return Integer.valueOf(strNum);
            }
            return Integer.valueOf(str);
        }

        @Override
        public boolean needConvert() {
            return true;
        }
    };
    private static TypeConvert smallint2Tinyint = new TypeConvert(){

        @Override
        public Object convert(Object input) {
            int result = 0;
            for (int i = 0; i < 8; ++i) {
                int bit = (Integer)input >> i & 1;
                if (bit != 1) continue;
                result += 1 << i;
            }
            return result;
        }

        @Override
        public boolean needConvert() {
            return true;
        }
    };
    private static Map<String, TypeConvert> typeConvertMap = new ConcurrentHashMap<String, TypeConvert>();
    private int actualType;
    private int parameterType;
    private TypeConvert convert;

    public PgCallstatementTypeCompatibility(int actualType, int parameterType) {
        this.actualType = actualType;
        this.parameterType = parameterType;
        this.convert = typeConvertMap.get(PgCallstatementTypeCompatibility.generateUniqueKey(actualType, parameterType));
        if (parameterType == 2000) {
            this.convert = noneConvert;
        }
    }

    public boolean isCompatibilityType() {
        return this.convert != null;
    }

    public boolean needConvert() {
        return this.convert.needConvert();
    }

    public Object convert(Object input) {
        return this.convert.convert(input);
    }

    private static void addConvert(int actualType, int parameterType, TypeConvert convert) {
        typeConvertMap.put(PgCallstatementTypeCompatibility.generateUniqueKey(actualType, parameterType), convert);
    }

    private static String generateUniqueKey(int firstKey, int secondKey) {
        return "" + firstKey + "|" + secondKey;
    }

    static {
        PgCallstatementTypeCompatibility.addConvert(8, 7, double2FloatConvert);
        PgCallstatementTypeCompatibility.addConvert(4, 12, stringConvert);
        PgCallstatementTypeCompatibility.addConvert(2, 12, stringConvert);
        PgCallstatementTypeCompatibility.addConvert(12, 2005, stringConvert);
        PgCallstatementTypeCompatibility.addConvert(12, -8, stringConvert);
        PgCallstatementTypeCompatibility.addConvert(2, 4, numeric2integer);
        PgCallstatementTypeCompatibility.addConvert(4, 2, noneConvert);
        PgCallstatementTypeCompatibility.addConvert(1111, -10, noneConvert);
        PgCallstatementTypeCompatibility.addConvert(1111, 2004, noneConvert);
        PgCallstatementTypeCompatibility.addConvert(2004, 1111, noneConvert);
        PgCallstatementTypeCompatibility.addConvert(5, -6, smallint2Tinyint);
    }

    private static interface TypeConvert {
        public Object convert(Object var1);

        public boolean needConvert();
    }
}

