/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.bulkload;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.postgresql.bulkload.BulkloadFileHandler;
import org.postgresql.bulkload.BulkloadIn;
import org.postgresql.bulkload.BulkloadOperation;
import org.postgresql.bulkload.BulkloadProperties;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.jdbc.BulkloadResultHandler;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class BulkloadManager {
    private static final Log LOGGER = Logger.getLogger(BulkloadManager.class.getName());
    static final int DEFAULT_BUFFER_SIZE = 65536;
    static final String DEFAULT_DELIMITER = ",";
    static final String DEFAULT_QUOTE = "#";
    static final String DEFAULT_ESCAPEQUOTE = "##";
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;
    private final BaseConnection connection;
    private final String bulkloadCtlFile;
    private BulkloadProperties bulkloadInfo;
    private final BulkloadResultHandler handler;
    private final BulkloadFileHandler fileHandler;
    private String startSql;
    private String[] columnValues;
    private int columnNums = 0;
    private StringBuilder cache;
    private BulkloadIn bulkloadIn = null;
    private String bulkloadScheme = "pgbulkload";
    private String bilkloadFunc = "pg_bulkload";
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equalsIgnoreCase("OUTPUT") || name.equalsIgnoreCase("TABLE")) {
                BulkloadManager.this.fetchColumnCount((String)evt.getNewValue());
            } else if (name.equalsIgnoreCase("IMP_FUNC")) {
                String func = (String)evt.getNewValue();
                if (func.equalsIgnoreCase("vb")) {
                    BulkloadManager.this.bulkloadScheme = "vbbl";
                    BulkloadManager.this.bilkloadFunc = "vb_bulkload";
                } else {
                    BulkloadManager.this.bulkloadScheme = "pgbulkload";
                    BulkloadManager.this.bilkloadFunc = "pg_bulkload";
                }
            }
            BulkloadManager.this.startSql = BulkloadManager.this.getBulkloadStartSQL();
        }
    };

    public BulkloadManager(BaseConnection connection, String bulkloadCtlFile) throws SQLException {
        this.encoding = connection.getEncoding();
        this.queryExecutor = connection.getQueryExecutor();
        this.connection = connection;
        this.bulkloadCtlFile = bulkloadCtlFile;
        this.handler = new BulkloadResultHandler((PgStatement)connection.createStatement());
        this.fileHandler = new BulkloadFileHandler(this);
        if (this.bulkloadCtlFile != null) {
            this.loadBulkloadCtlFile();
        }
    }

    public BulkloadIn bulkloadIn(String sql) throws SQLException {
        BulkloadOperation op = this.queryExecutor.startBulkload(this.handler, sql, false, this.initFlags());
        if (op != null && !(op instanceof BulkloadIn)) {
            op.cancelBulkload();
            throw new PSQLException(GT.tr("Requested bulkloadIn but got {0}", op), PSQLState.WRONG_OBJECT_TYPE);
        }
        return (BulkloadIn)op;
    }

    private BulkloadIn bulkloadInGetOperation(int flags) throws SQLException {
        LOGGER.trace("bulkload start sql: " + this.startSql);
        BulkloadOperation op = this.queryExecutor.startBulkload(this.handler, this.startSql, false, flags);
        if (op != null && !(op instanceof BulkloadIn)) {
            op.cancelBulkload();
            throw new PSQLException(GT.tr("Requested bulkloadIn but got {0}", op), PSQLState.WRONG_OBJECT_TYPE);
        }
        return (BulkloadIn)op;
    }

    public ResultSet bulkloadIn() throws SQLException {
        String inputValue = this.getBulkloadInfo().getProperty("INPUT");
        if ("stdin".equals(inputValue.toLowerCase())) {
            throw new PSQLException("For the parameter 'INPUT' of pg_bulkload, the binary file needs to be input when the value is 'STDIN'. use bulkloadIn(InputStream) or other functions.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        BulkloadIn op = this.bulkloadInGetOperation(this.initFlags());
        return this.handler.getResults().getResultSet();
    }

    public ResultSet bulkloadIn(InputStream from) throws SQLException, IOException {
        return this.bulkloadIn(from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet bulkloadIn(InputStream from, int bufferSize) throws SQLException, IOException {
        ResultSet resultSet;
        this.checkParams();
        int flags = this.initFlags();
        BulkloadIn cp = this.bulkloadInGetOperation(flags);
        if ((flags & 1) == 0) {
            return this.handler.getResults().getResultSet();
        }
        byte[] buf = new byte[bufferSize];
        try {
            int len;
            if (bufferSize < 1) {
                throw new PSQLException("bufferSize must bigger than 0", PSQLState.INVALID_PARAMETER_VALUE);
            }
            while ((len = from.read(buf)) >= 0) {
                cp.writeToBulkload(buf, 0, len);
            }
            ResultSet rs = cp.endBulkload();
            this.connection.execSQLUpdate("commit");
            resultSet = rs;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelBulkload();
            }
        }
        return resultSet;
    }

    public ResultSet bulkloadIn(String folderPath, Pattern fileNamePattern) throws SQLException, IOException {
        return this.bulkloadIn(this.fileHandler.getFilesFromFolder(folderPath, fileNamePattern));
    }

    public ResultSet bulkloadIn(String folderPath, Pattern fileNamePattern, int bufferSize) throws SQLException, IOException {
        return this.bulkloadIn(this.fileHandler.getFilesFromFolder(folderPath, fileNamePattern), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet bulkloadIn(File[] files, int bufferSize) throws SQLException, IOException {
        int flags = this.initFlags();
        BulkloadIn cp = this.bulkloadInGetOperation(flags);
        if ((flags & 1) == 0) {
            return this.handler.getResults().getResultSet();
        }
        FileInputStream fis = null;
        try {
            if (bufferSize < 1) {
                throw new PSQLException("bufferSize must bigger than 0", PSQLState.INVALID_PARAMETER_VALUE);
            }
            byte[] buf = new byte[bufferSize];
            for (File file : files) {
                int len;
                fis = new FileInputStream(file);
                while ((len = fis.read(buf)) >= 0) {
                    if (len <= 0) continue;
                    cp.writeToBulkload(buf, 0, len);
                }
                fis.close();
            }
            ResultSet result = cp.endBulkload();
            this.connection.execSQLUpdate("commit");
            ResultSet resultSet = result;
            return resultSet;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (cp.isActive()) {
                cp.cancelBulkload();
            }
        }
    }

    public ResultSet bulkloadIn(File[] files) throws SQLException, IOException {
        return this.bulkloadIn(files, 65536);
    }

    public StringBuffer escapeDoubleQuotesAndSlash(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str != null && !str.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                char item = str.charAt(i);
                if ('\"' != item && '\\' != item) {
                    stringBuffer.append(item);
                    continue;
                }
                stringBuffer.append('\\').append(item);
            }
        }
        return stringBuffer;
    }

    private void loadBulkloadCtlFile() throws PSQLException {
        if (this.bulkloadCtlFile != null) {
            try {
                FileInputStream fis = new FileInputStream(new File(this.bulkloadCtlFile));
                this.getBulkloadInfo().load(fis);
            }
            catch (IOException e) {
                throw new PSQLException("error with " + this.bulkloadCtlFile + " file :" + e.getMessage(), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    private void checkParams() throws PSQLException {
    }

    private int initFlags() {
        int flags = 0;
        String inputValue = this.getBulkloadInfo().getProperty("INPUT");
        if ("stdin".equals(inputValue.toLowerCase())) {
            flags |= 1;
        }
        return flags;
    }

    public String getBulkloadStartSQL() {
        return this.getBulkloadStartSQL(this.bulkloadScheme, this.bilkloadFunc);
    }

    public synchronized String getBulkloadStartSQL(String schemaName, String functionName) {
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(schemaName).append(".").append(functionName).append("('{");
        int index = 0;
        for (String key : this.bulkloadInfo.keySet()) {
            if (key.equalsIgnoreCase("COL") || key.equalsIgnoreCase("OUT_COL")) {
                for (String v : (List)this.bulkloadInfo.get(key)) {
                    if (index != 0) {
                        sql.append(DEFAULT_DELIMITER);
                    }
                    sql.append("\"").append(key).append("=").append(this.escapeDoubleQuotesAndSlash(v));
                    ++index;
                }
            } else if (!key.equalsIgnoreCase("IMP_FUNC")) {
                if (index != 0) {
                    sql.append(DEFAULT_DELIMITER);
                }
                sql.append("\"").append(key).append("=").append(this.escapeDoubleQuotesAndSlash((String)this.bulkloadInfo.get(key))).append("\"");
            } else {
                --index;
            }
            ++index;
        }
        sql.append("}')");
        return sql.toString();
    }

    public BulkloadProperties getBulkloadInfo() {
        if (this.bulkloadInfo == null) {
            this.bulkloadInfo = new BulkloadProperties();
            this.bulkloadInfo.addPropertyChangeListener(this.listener);
        }
        return this.bulkloadInfo;
    }

    public void setBulkloadInfo(BulkloadProperties bulkloadInfo) {
        this.bulkloadInfo = bulkloadInfo;
        bulkloadInfo.addPropertyChangeListener(this.listener);
        if ("vb".equalsIgnoreCase(bulkloadInfo.getProperty("IMP_FUNC"))) {
            this.bulkloadScheme = "vbbl";
            this.bilkloadFunc = "vb_bulkload";
        } else {
            this.bulkloadScheme = "pgbulkload";
            this.bilkloadFunc = "pg_bulkload";
        }
        this.startSql = this.getBulkloadStartSQL();
        String outputValue = bulkloadInfo.getProperty("OUTPUT");
        String tableValue = bulkloadInfo.getProperty("TABLE");
        String name = "";
        if (outputValue != null || tableValue != null) {
            name = outputValue != null ? outputValue : tableValue;
        }
        this.fetchColumnCount(name);
    }

    public void addBatch() {
        if (this.cache == null) {
            this.cache = new StringBuilder(65536);
        }
        if (this.columnValues != null) {
            for (String value : this.columnValues) {
                this.cache.append(value).append(DEFAULT_DELIMITER);
            }
            this.cache.setCharAt(this.cache.length() - 1, '\n');
        }
        this.columnValues = null;
    }

    public ResultSet executeBatch() throws IOException, SQLException {
        this.bulkloadInfo.setProperty("INPUT", "stdin");
        this.bulkloadInfo.setProperty("TYPE", "csv");
        this.bulkloadInfo.setProperty("DELIMITER", DEFAULT_DELIMITER);
        this.bulkloadInfo.setProperty("QUOTE", DEFAULT_QUOTE);
        this.bulkloadInfo.setProperty("ESCAPE", DEFAULT_QUOTE);
        this.bulkloadInfo.setProperty("TRUNCATE", "NO");
        this.bulkloadInfo.setProperty("NULL", "null");
        if (this.cache == null) {
            this.cache = new StringBuilder();
        }
        LOGGER.trace("bulkload cache :" + this.cache.toString());
        ResultSet resultSet = this.bulkloadIn(new ByteArrayInputStream(this.cache.toString().getBytes()));
        this.cache = null;
        return resultSet;
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        if (value == null) {
            return;
        }
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = DEFAULT_QUOTE + value.replaceAll(DEFAULT_QUOTE, DEFAULT_ESCAPEQUOTE) + DEFAULT_QUOTE;
    }

    public void setInt(int parameterIndex, Integer value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = Integer.toString(value);
    }

    public void setBoolean(int parameterIndex, Boolean value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = value != false ? "1" : "0";
    }

    public void setClob(int parameterIndex, Clob value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = DEFAULT_QUOTE + value.getSubString(1L, (int)value.length()).replaceAll(DEFAULT_QUOTE, DEFAULT_ESCAPEQUOTE) + DEFAULT_QUOTE;
    }

    public void setChar(int parameterIndex, Character value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = value.toString().equalsIgnoreCase(DEFAULT_QUOTE) ? "####" : value.toString();
    }

    public void setNumber(int parameterIndex, Number value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = value.toString();
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        if (parameterIndex > 0 && parameterIndex <= this.columnNums) {
            if (this.columnValues == null) {
                this.columnValues = new String[this.columnNums];
                Arrays.fill(this.columnValues, null);
            }
            if (value == null) {
                return;
            }
        } else {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.columnNums), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.columnValues[parameterIndex - 1] = value.toString();
    }

    private void fetchColumnCount(String name) {
        String tableName;
        ArrayList<String> schemaNames = new ArrayList<String>();
        String[] names = name.split("\\.");
        if (names.length == 2) {
            schemaNames.add(names[0]);
            tableName = names[1];
        } else {
            tableName = name;
            try {
                Statement statement = this.connection.createStatement();
                ResultSet rs = statement.executeQuery("show search_path");
                if (rs.next()) {
                    String[] paths;
                    for (String path : paths = rs.getString(1).split(DEFAULT_DELIMITER)) {
                        if (path.equalsIgnoreCase("\"$user\"")) {
                            schemaNames.add(this.connection.getMetaData().getUserName().toLowerCase());
                            continue;
                        }
                        schemaNames.add(path);
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.warn("could not get search_path:" + e.getMessage());
            }
        }
        String sql = "select a.relnatts,b.nspname from pg_class a join pg_namespace b on a.relnamespace = b.oid where a.relname = ? and b.nspname = ANY(?)";
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
            preparedStatement.setString(1, tableName);
            preparedStatement.setArray(2, this.connection.createArrayOf("text", schemaNames.toArray()));
            ResultSet rs = preparedStatement.executeQuery();
            boolean found = false;
            while (rs.next()) {
                for (String schemaName : schemaNames) {
                    if (!schemaName.equalsIgnoreCase(rs.getString(2))) continue;
                    this.columnNums = rs.getInt(1);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        catch (SQLException e) {
            LOGGER.warn("could not get table's column count:" + e.getMessage());
        }
    }
}

