/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.core.BaseStatement;
import cn.com.vastbase.core.ServerVersion;
import cn.com.vastbase.core.TypeInfo;
import cn.com.vastbase.jdbc.DbCompatibility;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.PGobject;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypeInfoCache
implements TypeInfo {
    private final Map<String, Integer> _pgNameToSQLType;
    private final Map<String, String> _pgNameToJavaClass;
    private final Map<Integer, String> _oidToPgName;
    private final Map<String, Integer> _pgNameToOid;
    private final Map<String, Class<? extends PGobject>> _pgNameToPgObject;
    private final Map<Integer, Integer> _pgArrayToPgType;
    private final Map<Integer, Character> _arrayOidToDelimiter;
    private ConcurrentHashMap<Integer, List<Object[]>> _compositeTypeMap = new ConcurrentHashMap();
    private final BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatementSimple;
    private PreparedStatement _getOidStatementComplexArray;
    private PreparedStatement _getOidStatementComplexNonArray;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private PreparedStatement _getCompositeTypeStatementSimple;
    private PreparedStatement _getAllTypeInfoStatement;
    private static final Object[][] types = new Object[][]{{"int1", 5545, -6, "java.lang.Integer", 5546}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"smalldatetime", 9003, 93, "java.lang.Timestamp", 9005}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamptz", 1184, 2014, "java.sql.Timestamp", 1185}, {"timetz", 1266, 2013, "java.sql.Time", 1270}, {"json", 114, 1111, "cn.com.vastbase.util.PGobject", 199}, {"point", 600, 1111, "cn.com.vastbase.geometric.PGpoint", 1017}, {"nvarchar2", 3969, 12, "java.lang.String", 3968}, {"blob", 88, 2004, "cn.com.vastbase.core.types.PGBlob", 3201}, {"clob", 90, 2005, "cn.com.vastbase.core.types.PGClob", 3202}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"rowid", 7301, -8, "cn.com.vastbase.core.types.ROWID", 7302}, {"binary", 9779, -2, "[B", 0}, {"oradate", 9040, 93, "java.sql.Timestamp", 9073}, {"jsonb", 3802, 1111, "cn.com.vastbase.util.PGobject", 3807}, {"raw", 86, -2, "[B", 87}, {"jsonpath", 4072, 12, "java.lang.String", 4073}, {"long", 93, 12, "java.lang.String", null}, {"long_raw", 94, -2, "[B", null}, {"sql_variant", 96, 1111, "cn.com.vastbase.util.PGobject", 0}, {"varbinary", 95, -3, "[B", 0}, {"datetime2", 5950, 93, "java.sql.Timestamp", 5951}, {"mssql_datetime", 9008, 93, "java.sql.Timestamp", 9009}, {"image", 97, -4, "[B", 0}, {"number", 1399, 2, "java.math.BigDecimal", 1232}, {"blob", 3399, 2004, "cn.com.vastbase.core.types.PGBlob", 3400}, {"uint1", 0, 5, "java.lang.Integer", 0}, {"uint2", 0, 4, "java.lang.Integer", 0}, {"uint4", 0, -5, "java.lang.Long", 0}, {"uint8", 0, 1111, "java.math.BigInteger", 0}};
    private static final HashMap<String, String> typeAliases = new HashMap();
    private static final ConcurrentHashMap<Integer, Integer> pricisionToInteger;
    private static final ConcurrentHashMap<Integer, Integer> oidToInteger;

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap<Integer, String>();
        this._pgNameToOid = new HashMap<String, Integer>();
        this._pgNameToJavaClass = new HashMap<String, String>();
        this._pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>();
        this._pgArrayToPgType = new HashMap<Integer, Integer>();
        this._arrayOidToDelimiter = new HashMap<Integer, Character>();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, 2003);
        this._pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this._pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this._pgNameToSQLType.put(pgArrayTypeName, 2003);
            this._pgNameToOid.put(pgArrayTypeName, arrayOid);
            this._oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    public int getPGTypeName(String pgTypName) {
        return this._pgNameToSQLType.get(pgTypName);
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    private String getSQLTypeQuery(boolean typoidParam) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT typinput='array_in'::regproc as is_array, typtype, typname ");
        sql.append("  FROM pg_catalog.pg_type ");
        sql.append("  LEFT JOIN (select ns.oid as nspoid, ns.nspname, r.r ");
        sql.append("          from pg_namespace as ns ");
        sql.append("          join ( select s.r, (current_schemas(false))[s.r] as nspname ");
        sql.append("                   from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r ");
        sql.append("         using ( nspname ) ");
        sql.append("       ) as sp ");
        sql.append("    ON sp.nspoid = typnamespace ");
        if (typoidParam) {
            sql.append(" WHERE pg_type.oid = ? ");
        }
        sql.append(" ORDER BY sp.r, pg_type.oid DESC;");
        return sql.toString();
    }

    private int getSQLTypeFromQueryResult(ResultSet rs) throws SQLException {
        Integer type = null;
        boolean isArray = rs.getBoolean("is_array");
        String typtype = rs.getString("typtype");
        if (isArray) {
            type = 2003;
        } else if ("c".equals(typtype) || "a".equals(typtype)) {
            type = 2002;
        } else if ("d".equals(typtype)) {
            type = 2001;
        } else if ("e".equals(typtype)) {
            type = 12;
        }
        if (type == null) {
            type = 1111;
        }
        return type;
    }

    private PreparedStatement prepareGetAllTypeInfoStatement() throws SQLException {
        PreparedStatement getAllTypeInfoStatement = this._getAllTypeInfoStatement;
        if (getAllTypeInfoStatement == null) {
            this._getAllTypeInfoStatement = getAllTypeInfoStatement = this._conn.prepareStatement(this.getSQLTypeQuery(false));
        }
        return getAllTypeInfoStatement;
    }

    public void cacheSQLTypes() throws SQLException {
        if (this._getAllTypeInfoStatement == null) {
            this._getAllTypeInfoStatement = this.prepareGetAllTypeInfoStatement();
        }
        if (!((BaseStatement)((Object)this._getAllTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getAllTypeInfoStatement.getResultSet();
        while (rs.next()) {
            String typeName = rs.getString("typname");
            Integer type = this.getSQLTypeFromQueryResult(rs);
            if (this._pgNameToSQLType.containsKey(typeName)) continue;
            this._pgNameToSQLType.put(typeName, type);
        }
        rs.close();
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        if (this._getTypeInfoStatement == null) {
            this._getTypeInfoStatement = this._conn.prepareStatement(this.getSQLTypeQuery(true));
        }
        this._getTypeInfoStatement.setLong(1, this.intOidToLong(this.getPGType(pgTypeName)));
        if (!((BaseStatement)((Object)this._getTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            type = this.getSQLTypeFromQueryResult(rs);
        }
        rs.close();
        if (type == null) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        this._pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        String name;
        String schema;
        String fullName;
        PreparedStatement oidStatementComplex;
        String sql;
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        if (dotIndex == -1 && !hasQuote && !isArray) {
            if (this._getOidStatementSimple == null) {
                String sql2 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this._getOidStatementSimple = this._conn.prepareStatement(sql2);
            }
            String lcName = pgTypeName.toLowerCase(Locale.ROOT);
            this._getOidStatementSimple.setString(1, lcName);
            return this._getOidStatementSimple;
        }
        if (isArray) {
            if (this._getOidStatementComplexArray == null) {
                sql = this._conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this._getOidStatementComplexArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this._getOidStatementComplexArray;
        } else {
            if (this._getOidStatementComplexNonArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this._getOidStatementComplexNonArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this._getOidStatementComplexNonArray;
        }
        String string = fullName = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase(Locale.ROOT);
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase(Locale.ROOT);
        oidStatementComplex.setString(1, name);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this._oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this._pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this._pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this._pgNameToOid.put(pgTypeName, oid);
            this._oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        int pgType = 0;
        for (String newTypeName : new String[]{TypeInfoCache.combainStringIfOneQuoted("_", elementTypeName), TypeInfoCache.combainStringIfOneQuoted(elementTypeName, "[]"), elementTypeName}) {
            pgType = this.getPGType(newTypeName);
            if (pgType == 0) continue;
            return pgType;
        }
        return pgType;
    }

    private static String combainStringIfOneQuoted(String first, String second) {
        if (first.startsWith("\"")) {
            return first.substring(0, first.length() - 1) + second + "\"";
        }
        if (second.startsWith("\"")) {
            return "\"" + first + second.substring(1);
        }
        return first + second;
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this._pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this._arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this._arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this._pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this._pgArrayToPgType.put(oid, pgType);
        this._pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this._pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this._oidToPgName.put(pgType, name);
            this._pgNameToOid.put(name, pgType);
        } else {
            this._oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this._pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName;
        String result;
        if (DbCompatibility.ORACLE == this._conn.getDbCompatibility()) {
            switch (this.getSQLType(oid)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return "java.math.BigDecimal";
                }
            }
        }
        if ((result = this._pgNameToJavaClass.get(pgTypeName = this.getPGType(oid))) != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        if (pricisionToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return pricisionToInteger.get(oid);
        }
        switch (oid) {
            case 1399: 
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 9003: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1399: 
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: 
            case 5545: 
            case 9003: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    private int getValueOfTime(int oid, int typmod) {
        int secondSize;
        switch (typmod) {
            case -1: {
                secondSize = 7;
                break;
            }
            case 0: {
                secondSize = 0;
                break;
            }
            case 1: {
                secondSize = 3;
                break;
            }
            default: {
                secondSize = typmod + 1;
            }
        }
        switch (oid) {
            case 1083: {
                return 8 + secondSize;
            }
            case 1266: {
                return 8 + secondSize + 6;
            }
            case 9003: {
                return 22;
            }
            case 1114: {
                return 22 + secondSize;
            }
        }
        return 22 + secondSize + 6;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        if (oidToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return oidToInteger.get(oid);
        }
        switch (oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 9003: {
                return this.getValueOfTime(oid, typmod);
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this._unknownLength;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: 
            case 9003: {
                return 6;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    private PreparedStatement getCompositeTypeStatement(int oid) throws SQLException {
        if (this._getCompositeTypeStatementSimple == null) {
            String sql = "SELECT attname, atttypid FROM pg_attribute a JOIN pg_class c ON a.attrelid = c.oid WHERE c.oid IN ( SELECT a.typrelid FROM ( SELECT pn.nspname || '.' || pt.typname AS typname, pt.typrelid, pt.oid as oid FROM pg_namespace pn LEFT JOIN pg_type pt ON pn.oid = pt.typnamespace) a WHERE  a.oid = ? ) AND a.attnum > 0 ORDER BY a.attnum";
            this._getCompositeTypeStatementSimple = this._conn.prepareStatement(sql);
        }
        this._getCompositeTypeStatementSimple.setInt(1, oid);
        return this._getCompositeTypeStatementSimple;
    }

    @Override
    public List<Object[]> getPGStrut(int oid) throws SQLException {
        if (this._compositeTypeMap.containsKey(oid)) {
            return this._compositeTypeMap.get(oid);
        }
        PreparedStatement compositeTypeStatement = this.getCompositeTypeStatement(oid);
        if (!((BaseStatement)((Object)compositeTypeStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = compositeTypeStatement.getResultSet();
        ArrayList<Object[]> compositeType = new ArrayList<Object[]>();
        while (rs.next()) {
            compositeType.add(new Object[]{rs.getString(1), rs.getInt(2)});
        }
        this._compositeTypeMap.put(oid, compositeType);
        rs.close();
        return this._compositeTypeMap.get(oid);
    }

    @Override
    public int longOidToInt(long oid) throws SQLException {
        if ((oid & 0xFFFFFFFF00000000L) != 0L) {
            throw new PSQLException(GT.tr("Value is not an OID: {0}", oid), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (int)oid;
    }

    @Override
    public long intOidToLong(int oid) {
        return (long)oid & 0xFFFFFFFFL;
    }

    static {
        typeAliases.put("tinyint", "int1");
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
        pricisionToInteger = new ConcurrentHashMap();
        pricisionToInteger.put(5545, 3);
        pricisionToInteger.put(21, 5);
        pricisionToInteger.put(26, 10);
        pricisionToInteger.put(23, 10);
        pricisionToInteger.put(20, 19);
        pricisionToInteger.put(700, 8);
        pricisionToInteger.put(701, 17);
        pricisionToInteger.put(18, 1);
        pricisionToInteger.put(16, 1);
        oidToInteger = new ConcurrentHashMap();
        oidToInteger.put(5545, 3);
        oidToInteger.put(21, 6);
        oidToInteger.put(23, 11);
        oidToInteger.put(26, 10);
        oidToInteger.put(20, 20);
        oidToInteger.put(700, 15);
        oidToInteger.put(701, 25);
        oidToInteger.put(18, 1);
        oidToInteger.put(16, 1);
        oidToInteger.put(1082, 13);
        oidToInteger.put(1186, 49);
    }
}

