/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase;

import cn.com.vastbase.log.Log;
import cn.com.vastbase.log.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class AESGCMUtil {
    private static final Log LOGGER = Logger.getLogger(AESGCMUtil.class.getName());
    public static final int GCM_TAG_LENGTH = 16;
    public static final int GCM_IV_LENGTH = 12;
    public static final int AES_KEY_SIZE = 128;

    public String encryptGCM(String password, String plaintext) {
        byte[] ciphertext = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] initVector = new byte[12];
            new SecureRandom().nextBytes(initVector);
            GCMParameterSpec spec = new GCMParameterSpec(128, initVector);
            SecretKeySpec secretKeySpec = AESGCMUtil.getSecretKeySpec(password);
            cipher.init(1, (Key)secretKeySpec, spec);
            byte[] encoded = plaintext.getBytes(StandardCharsets.UTF_8);
            ciphertext = new byte[initVector.length + cipher.getOutputSize(encoded.length)];
            for (int i = 0; i < initVector.length; ++i) {
                ciphertext[i] = initVector[i];
            }
            cipher.doFinal(encoded, 0, encoded.length, ciphertext, initVector.length);
            return DatatypeConverter.printBase64Binary((byte[])ciphertext);
        }
        catch (InvalidKeyException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (NoSuchPaddingException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (ShortBufferException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (BadPaddingException e) {
            LOGGER.info("encropt failed. except error", e);
        }
        catch (Exception e) {
            LOGGER.info("encropt failed.", e);
        }
        return "";
    }

    public String decryptGCM(String password, String encryptedtext) {
        byte[] decryptFrom = DatatypeConverter.parseBase64Binary((String)encryptedtext);
        byte[] plaintext = null;
        byte[] initVector = new byte[12];
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            System.arraycopy(decryptFrom, 0, initVector, 0, 12);
            GCMParameterSpec spec = new GCMParameterSpec(128, initVector);
            SecretKeySpec secretKeySpec = AESGCMUtil.getSecretKeySpec(password);
            cipher.init(2, (Key)secretKeySpec, spec);
            plaintext = cipher.doFinal(decryptFrom, 12, decryptFrom.length - 12);
            return new String(plaintext, StandardCharsets.UTF_8);
        }
        catch (NoSuchPaddingException e) {
            LOGGER.info("decropt failed. except error", e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("decropt failed. except error", e);
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.info("decropt failed. except error", e);
        }
        catch (BadPaddingException e) {
            LOGGER.info("decropt failed. except error", e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info("decropt failed. except error", e);
        }
        catch (Exception e) {
            LOGGER.info("decropt failed. except error", e);
        }
        return "";
    }

    public static SecretKeySpec getSecretKeySpec(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password.getBytes(StandardCharsets.UTF_8));
        keygen.init(128, secureRandom);
        SecretKey secretKey = keygen.generateKey();
        byte[] keyByte = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyByte, "AES");
        return secretKeySpec;
    }
}

