/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.kit.annotation.manager;

import cn.com.twoke.kit.annotation.AnnotationMetadata;
import cn.com.twoke.kit.annotation.manager.AnnotationCompatibleManager;
import cn.com.twoke.kit.annotation.manager.ExtensionField;
import cn.com.twoke.kit.runnable.RunnableWithParameterAndReturn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class AnnotationManager<T>
extends HashMap<Class<? extends Annotation>, ExtensionField>
implements AnnotationCompatibleManager<T> {
    private Class<T> annotationInterface;

    private AnnotationManager(Class<T> annotationInterface) {
        this.annotationInterface = annotationInterface;
    }

    public static <D> AnnotationManager build(Class<D> annotationInterface) {
        return new AnnotationManager<D>(annotationInterface);
    }

    @Override
    public void register(Class<? extends Annotation> annotationType) {
        this.put(annotationType, null);
    }

    @Override
    public void register(Class<? extends Annotation> annotationType, ExtensionField extensionField) {
        this.put(annotationType, extensionField);
    }

    @Override
    public T getAnnotationBy(Method method) {
        return this.getAnnotationInterfaceInstance(clazz -> method.getDeclaredAnnotation(clazz));
    }

    @Override
    public T getAnnotationBy(Constructor<?> constructor) {
        return this.getAnnotationInterfaceInstance(clazz -> constructor.getDeclaredAnnotation((Class<?>)clazz));
    }

    @Override
    public T getAnnotationBy(Field field) {
        return this.getAnnotationInterfaceInstance(clazz -> field.getDeclaredAnnotation(clazz));
    }

    @Override
    public T getAnnotationBy(Class<?> method) {
        return this.getAnnotationInterfaceInstance(clazz -> method.getDeclaredAnnotation(clazz));
    }

    @Override
    public T getAnnotationBy(Parameter parameter) {
        return this.getAnnotationInterfaceInstance(clazz -> parameter.getDeclaredAnnotation(clazz));
    }

    private T getAnnotationInterfaceInstance(RunnableWithParameterAndReturn<Class<? extends Annotation>, Annotation> runnableWithReturn) {
        AtomicReference annotationMetadataAtomicReference = new AtomicReference();
        this.keySet().forEach((? super T annotationClass) -> {
            Annotation annotation = (Annotation)runnableWithReturn.run((Class<? extends Annotation>)annotationClass);
            if (Objects.nonNull(annotation)) {
                AnnotationMetadata annotationMetadata = AnnotationMetadata.build(annotation);
                ExtensionField extensionField = (ExtensionField)this.get(annotationClass);
                if (Objects.nonNull(extensionField)) {
                    annotationMetadata = (AnnotationMetadata)extensionField.run(annotationMetadata);
                }
                annotationMetadataAtomicReference.set(annotationMetadata);
                return;
            }
        });
        final AnnotationMetadata annotationMetadata = (AnnotationMetadata)annotationMetadataAtomicReference.get();
        if (Objects.isNull(annotationMetadata)) {
            throw new IllegalStateException("\u6ca1\u6709\u4f7f\u7528\u6ce8\u89e3\u63a5\u53e3");
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.annotationInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                return annotationMetadata.get(methodName);
            }
        });
    }
}

