/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class PackageScan {
    private String basePackage;
    private ClassLoader cl;
    private String matchUrl = "";

    public PackageScan(String basePackage) {
        this.matchUrl = "^" + basePackage.replaceAll("\\.", "\\.").replace("*", "(\\S+)") + "((\\.\\S+)+)";
        if (basePackage.contains("*") && (basePackage = basePackage.split("\\*")[0]).endsWith(".")) {
            basePackage = basePackage.substring(0, basePackage.length() - 1);
        }
        this.basePackage = basePackage;
        this.cl = this.getClass().getClassLoader();
    }

    public PackageScan(String basePackage, ClassLoader cl) {
        this.basePackage = basePackage;
        this.cl = cl;
    }

    public List<String> getFullyQualifiedClassNameList() throws IOException {
        return this.doScan(this.basePackage, new ArrayList<String>());
    }

    private List<String> doScan(String packageName, List<String> nameList) throws IOException {
        String splashPath = PackageScan.dotToSplash(packageName);
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageName);
        while (dirs.hasMoreElements()) {
            this.forScan(dirs.nextElement(), splashPath, nameList, packageName);
        }
        return nameList;
    }

    private List<String> doChildScan(String packageName, List<String> nameList) throws IOException {
        String splashPath = PackageScan.dotToSplash(packageName);
        URL url = this.cl.getResource(splashPath);
        this.forScan(url, splashPath, nameList, packageName);
        return nameList;
    }

    public List<String> forScan(URL url, String splashPath, List<String> nameList, String packageName) throws IOException {
        String filePath = PackageScan.getRootPath(url);
        List<String> names = null;
        if (this.isJarFile(filePath)) {
            try {
                names = this.readFromJarFile(filePath, splashPath);
            }
            catch (IOException e) {
                names = new ArrayList<String>();
            }
        } else {
            names = this.readFromDirectory(filePath);
        }
        for (String name : names) {
            if (this.isClassFile(name)) {
                String className = this.toFullyQualifiedName(name, packageName);
                if (!className.matches(this.matchUrl)) continue;
                nameList.add(className);
                continue;
            }
            this.doChildScan(packageName + "." + name, nameList);
        }
        return nameList;
    }

    private String toFullyQualifiedName(String shortName, String packageName) {
        StringBuilder sb = new StringBuilder(packageName);
        sb.append('.');
        sb.append(this.trimExtension(shortName));
        String className = sb.toString();
        if (className.matches(this.matchUrl)) {
            return className;
        }
        return className;
    }

    private List<String> readFromJarFile(String jarPath, String splashedPackageName) throws IOException {
        JarInputStream jarIn = new JarInputStream(new FileInputStream(jarPath));
        JarEntry entry = jarIn.getNextJarEntry();
        ArrayList<String> nameList = new ArrayList<String>();
        while (null != entry) {
            String name = entry.getName();
            if (name.startsWith(splashedPackageName) && this.isClassFile(name) && !name.matches(this.matchUrl)) {
                nameList.add(name);
            }
            entry = jarIn.getNextJarEntry();
        }
        return nameList;
    }

    private List<String> readFromDirectory(String path) {
        File file = new File(path);
        String[] names = file.list();
        if (null == names) {
            return null;
        }
        return Arrays.asList(names);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    private boolean isJarFile(String name) {
        return name.endsWith(".jar");
    }

    public static String getRootPath(URL url) {
        String fileUrl = url.getFile();
        int pos = fileUrl.indexOf(33);
        if (-1 == pos) {
            return fileUrl;
        }
        return fileUrl.substring(5, pos);
    }

    public static String dotToSplash(String name) {
        return name.replaceAll("\\.", "/");
    }

    public String trimExtension(String name) {
        if (this.isClassFile(name)) {
            if ((name = name.replaceAll("/", ".").replaceAll(this.basePackage, "")).startsWith(".")) {
                return name.substring(1, name.lastIndexOf("."));
            }
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static String trimURI(String uri) {
        String trimmed = uri.substring(1);
        int splashIndex = trimmed.indexOf(47);
        return trimmed.substring(splashIndex);
    }
}

