/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.mapper;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ClassPathScanHandler {
    private static final Logger logger = Logger.getLogger(ClassPathScanHandler.class);
    private boolean excludeInner = true;
    private boolean checkInOrEx = true;
    private List<String> classFilters = null;

    public ClassPathScanHandler() {
    }

    public ClassPathScanHandler(Boolean excludeInner, Boolean checkInOrEx, List<String> classFilters) {
        this.excludeInner = excludeInner;
        this.checkInOrEx = checkInOrEx;
        this.classFilters = classFilters;
    }

    public Set<Class<?>> getPackageAllClasses(String basePackage, boolean recursive) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    logger.info((Object)"\u626b\u63cffile\u7c7b\u578b\u7684class\u6587\u4ef6....");
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.doScanPackageClassesByFile(classes, packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                logger.info((Object)"\u626b\u63cfjar\u6587\u4ef6\u4e2d\u7684\u7c7b....");
                this.doScanPackageClassesByJar(packageName, url, recursive, classes);
            }
        }
        catch (IOException e) {
            logger.error((Object)"IOException error:", (Throwable)e);
        }
        return classes;
    }

    private void doScanPackageClassesByJar(String basePackage, URL url, boolean recursive, Set<Class<?>> classes) {
        String packageName = basePackage;
        String package2Path = packageName.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(package2Path) || entry.isDirectory() || !recursive && name.lastIndexOf(47) != package2Path.length()) continue;
                if (this.excludeInner && name.indexOf(36) != -1) {
                    logger.info((Object)("exclude inner class with name:" + name));
                    continue;
                }
                String classSimpleName = name.substring(name.lastIndexOf(47) + 1);
                if (!this.filterClassName(classSimpleName)) continue;
                String className = name.replace('/', '.');
                className = className.substring(0, className.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"Class.forName error:", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"IOException error:", (Throwable)e);
        }
    }

    private void doScanPackageClassesByFile(Set<Class<?>> classes, String packageName, String packagePath, boolean recursive) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        final boolean fileRecursive = recursive;
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return fileRecursive;
                }
                String filename = file.getName();
                if (ClassPathScanHandler.this.excludeInner && filename.indexOf(36) != -1) {
                    logger.info((Object)("exclude inner class with name:" + filename));
                    return false;
                }
                return ClassPathScanHandler.this.filterClassName(filename);
            }
        })) {
            if (file.isDirectory()) {
                this.doScanPackageClassesByFile(classes, packageName + "." + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"IOException error:", (Throwable)e);
            }
        }
    }

    private boolean filterClassName(String className) {
        if (!className.endsWith(".class")) {
            return false;
        }
        if (null == this.classFilters || this.classFilters.isEmpty()) {
            return true;
        }
        String tmpName = className.substring(0, className.length() - 6);
        boolean flag = false;
        for (String str : this.classFilters) {
            String tmpreg = "^" + str.replace("*", ".*") + "$";
            Pattern p = Pattern.compile(tmpreg);
            if (!p.matcher(tmpName).find()) continue;
            flag = true;
            break;
        }
        return this.checkInOrEx && flag || !this.checkInOrEx && !flag;
    }

    public boolean isExcludeInner() {
        return this.excludeInner;
    }

    public boolean isCheckInOrEx() {
        return this.checkInOrEx;
    }

    public List<String> getClassFilters() {
        return this.classFilters;
    }

    public void setExcludeInner(boolean pExcludeInner) {
        this.excludeInner = pExcludeInner;
    }

    public void setCheckInOrEx(boolean pCheckInOrEx) {
        this.checkInOrEx = pCheckInOrEx;
    }

    public void setClassFilters(List<String> pClassFilters) {
        this.classFilters = pClassFilters;
    }

    public static void main(String[] args) {
        ArrayList<String> classFilters = new ArrayList<String>();
        classFilters.add("File*");
        ClassPathScanHandler handler = new ClassPathScanHandler(true, true, classFilters);
        System.out.println("\u5f00\u59cb\u9012\u5f52\u626b\u63cfjar\u6587\u4ef6\u7684\u5305\uff1aorg.apache.commons.io \u4e0b\u7b26\u5408\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u89c4\u5219\u7684\u7c7b...");
        Set<Class<?>> calssList = handler.getPackageAllClasses("com", true);
        for (Class<?> cla : calssList) {
            System.out.println(cla.getName());
        }
        System.out.println("\u5f00\u59cb\u9012\u5f52\u626b\u63cffile\u6587\u4ef6\u7684\u5305\uff1amichael.hessian \u4e0b\u7b26\u5408\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u89c4\u5219\u7684\u7c7b...");
        classFilters.clear();
        classFilters.add("Hessian*");
        calssList = handler.getPackageAllClasses("michael.hessian", true);
        for (Class<?> cla : calssList) {
            System.out.println(cla.getName());
        }
    }
}

