/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.jdbc;

import cn.com.louie.config.Configuration;
import cn.com.louie.jdbc.EntityNotFoundException;
import cn.com.louie.jdbc.Executor;
import cn.com.louie.jdbc.SqlSession;
import cn.com.louie.mapper.EOUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DefaultSqlSession
implements SqlSession {
    private Executor executor;

    public DefaultSqlSession(Executor executor) {
        this.executor = executor;
    }

    @Override
    public <T> T load(Object Id2, Class<T> clazz) {
        EOUtil eoUtil = Configuration.getInstans().eoutils.get(clazz);
        if (eoUtil == null) {
            throw new EntityNotFoundException("\u9700\u8981\u5728\u5b9e\u4f53\u4e0a\u52a0\u5165@Entity\u6807\u6ce8");
        }
        String sql = eoUtil.buildSelect(eoUtil.primaryKey + "=?");
        return this.getOne(sql, Id2, clazz);
    }

    @Override
    public <T> T findBySQL(String sql, Object parms, Class<T> clazz) {
        return this.getOne(sql, parms, clazz);
    }

    @Override
    public <T> T findByWhereSQL(String whereSql, Object parms, Class<T> clazz) {
        EOUtil eoUtil = Configuration.getInstans().eoutils.get(clazz);
        if (eoUtil == null) {
            throw new EntityNotFoundException("\u9700\u8981\u5728\u5b9e\u4f53\u4e0a\u52a0\u5165@Entity\u6807\u6ce8");
        }
        String sql = eoUtil.buildSelect(whereSql);
        return this.getOne(sql, parms, clazz);
    }

    @Override
    public <E> List<E> queryBySQL(String sql, Object parms, Class<E> clazz) {
        return this.getList(sql, parms, clazz);
    }

    @Override
    public <E> List<E> queryByWhereSQL(String whereSql, Object parms, Class<E> clazz) {
        EOUtil eoUtil = Configuration.getInstans().eoutils.get(clazz);
        if (eoUtil == null) {
            throw new EntityNotFoundException("\u9700\u8981\u5728\u5b9e\u4f53\u4e0a\u52a0\u5165@Entity\u6807\u6ce8");
        }
        String sql = eoUtil.buildSelect(whereSql);
        return this.getList(sql, parms, clazz);
    }

    @Override
    public List queryBySQL(String sql, Object parms) {
        return this.executor.Query(sql, parms);
    }

    @Override
    public Map<String, Object> findBySQL(String sql, Object parms) {
        List list = this.executor.Query(sql, parms);
        return CollectionUtils.isEmpty((Collection)list) ? null : (Map)list.get(0);
    }

    @Override
    public int updateBySQL(String sql, Object parms) {
        return this.executor.updateBySQL(sql, parms);
    }

    @Override
    public int update(Object t) {
        EOUtil eoUtil = Configuration.getInstans().eoutils.get(t.getClass());
        if (eoUtil == null) {
            throw new EntityNotFoundException("\u9700\u8981\u5728\u5b9e\u4f53\u4e0a\u52a0\u5165@Entity\u6807\u6ce8");
        }
        String sql = eoUtil.buildUpdate(null, t);
        return this.executor.updateBySQL(sql, null);
    }

    @Override
    public Object insert(Object t) {
        EOUtil eoUtil = Configuration.getInstans().eoutils.get(t.getClass());
        if (eoUtil == null) {
            throw new EntityNotFoundException("\u9700\u8981\u5728\u5b9e\u4f53\u4e0a\u52a0\u5165@Entity\u6807\u6ce8");
        }
        String sql = eoUtil.buildInsert(t);
        return this.executor.insertBySQL(sql, null);
    }

    @Override
    public Object insertBySQL(String sql, Object parms) {
        return this.executor.insertBySQL(sql, parms);
    }

    @Override
    public Connection getConnection() {
        try {
            return Configuration.getInstans().dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <E> List<E> getList(String sql, Object parm, Class c) {
        try {
            List list = this.executor.doQuery(sql, parm, c);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private <T> T getOne(String sql, Object parm, Class c) {
        try {
            List list = this.executor.doQuery(sql, parm, c);
            return CollectionUtils.isEmpty(list) ? null : (T)list.get(0);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void close() {
        this.executor.close();
    }
}

