/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie;

import cn.com.louie.config.Configuration;
import cn.com.louie.jdbc.DefaultSqlSessionFactory;
import cn.com.louie.jdbc.SqlSessionFactory;
import cn.com.louie.mapper.EOUtil;
import cn.com.louie.mapper.Entity;
import cn.com.louie.mapper.PackageScan;
import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class SqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean {
    private String packageScan;
    private DataSource dataSource;
    private boolean useCache;
    private SqlSessionFactory sqlSessionFactory;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        Configuration.getInstans().dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setPackageScan(String scan) {
        PackageScan packageScan = new PackageScan(scan);
        List<String> classes = null;
        try {
            classes = packageScan.getFullyQualifiedClassNameList();
            for (String className : classes) {
                Class<?> clazz = Class.forName(className, true, this.getClass().getClassLoader());
                System.out.println(clazz.getCanonicalName() + "**************");
                System.out.println(clazz.getSimpleName() + "**************");
                System.out.println(clazz);
                if (!clazz.isAnnotationPresent(Entity.class)) continue;
                Configuration.getInstans().eoutils.put(clazz.getName(), new EOUtil(clazz));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setUseCache(boolean useCache) {
        Configuration.getInstans().useCache = useCache;
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.sqlSessionFactory = new DefaultSqlSessionFactory();
    }

    public String getPackageScan() {
        return this.packageScan;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }
}

