/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.jdbc;

import cn.com.louie.cache.Cache;
import cn.com.louie.cache.CacheKey;
import cn.com.louie.cache.PerpetualCache;
import cn.com.louie.config.Configuration;
import cn.com.louie.jdbc.Executor;
import cn.com.louie.mapper.EOUtil;
import cn.com.louie.mapper.QType;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.util.CollectionUtils;

public class DefaultExecutor
implements Executor {
    private static final Logger logger = Logger.getLogger("DefaultExecutor");
    private Cache localCache = new PerpetualCache("LocalCache");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> List<E> doQuery(String sql, Object parms, Class eClass) throws IllegalAccessException, InstantiationException {
        CacheKey cacheKey = new CacheKey(new Object[]{sql, parms});
        ArrayList<Object> list = (ArrayList<Object>)this.localCache.getObject(cacheKey);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            connection = Configuration.getInstans().dataSource.getConnection();
            statement = connection.prepareStatement(sql);
            this.setParms(parms, statement);
            resultSet = statement.executeQuery();
            Object o = null;
            list = new ArrayList<Object>();
            EOUtil eoUtil = Configuration.getInstans().eoutils.get(eClass.getSimpleName());
            Map<String, QType> map = eoUtil.getColums();
            while (resultSet.next()) {
                o = eClass.newInstance();
                this.mapRow(map, resultSet, eoUtil, o);
                list.add(o);
            }
            this.localCache.putObject(cacheKey, list);
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            logger.info(e.getMessage());
            e.printStackTrace();
            List<E> list2 = null;
            return list2;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateBySQL(String sql, Object parms) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = Configuration.getInstans().dataSource.getConnection();
            statement = connection.prepareStatement(sql);
            this.setParms(parms, (PreparedStatement)statement);
            int count = statement.executeUpdate();
            if (count > 0) {
                this.localCache.clear();
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insertBySQL(String sql, Object parms) {
        Connection connection = null;
        Statement statement = null;
        try {
            ResultSet resultSet;
            connection = Configuration.getInstans().dataSource.getConnection();
            statement = connection.prepareStatement(sql, 1);
            this.setParms(parms, (PreparedStatement)statement);
            int count = statement.executeUpdate();
            Object res = null;
            if (count > 0) {
                resultSet = statement.getGeneratedKeys();
                while (resultSet.next()) {
                    res = resultSet.getObject(1);
                }
                this.localCache.clear();
            }
            resultSet = res;
            return resultSet;
        }
        catch (SQLException e) {
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List Query(String sql, Object parms) {
        CacheKey cacheKey = new CacheKey(new Object[]{sql, parms});
        if (this.localCache.getObject(cacheKey) != null) {
            return (List)this.localCache.getObject(cacheKey);
        }
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            connection = Configuration.getInstans().dataSource.getConnection();
            statement = connection.prepareStatement(sql);
            this.setParms(parms, statement);
            resultSet = statement.executeQuery();
            ResultSetMetaData md = resultSet.getMetaData();
            ArrayList list = new ArrayList();
            HashMap<String, Object> map = null;
            int i = 0;
            while (resultSet.next()) {
                map = new HashMap<String, Object>();
                map.put(md.getColumnName(i), resultSet.getObject(i));
                list.add(map);
                ++i;
            }
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private CacheKey createCacheKey(String sql, Object perms) {
        return new CacheKey(new Object[]{sql, perms});
    }

    private void mapRow(Map<String, QType> map, ResultSet row, EOUtil eoUtil, Object o) {
        for (Map.Entry<String, QType> entry : map.entrySet()) {
            try {
                eoUtil.setAttributeValue(entry.getKey(), row.getObject(entry.getValue().getKey()), o);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void setParms(Object parms, PreparedStatement statement) throws SQLException {
        if (parms != null) {
            if (parms.getClass().isArray()) {
                for (int i = 1; i <= Array.getLength(parms); ++i) {
                    statement.setObject(i, Array.get(parms, i - 1));
                }
            } else {
                statement.setObject(1, parms);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

