/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.jdbc;

import cn.com.louie.cache.Cache;
import cn.com.louie.cache.CacheKey;
import cn.com.louie.config.Configuration;
import cn.com.louie.jdbc.Executor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class CacheExecutor
implements Executor {
    private Executor baseExecutor;
    private Cache cache;

    public CacheExecutor(Executor baseExecutor) {
        this.cache = Configuration.getInstans().cache;
        this.baseExecutor = baseExecutor;
    }

    @Override
    public <E> List<E> doQuery(String sql, Object parms, Class clazz) throws SQLException, IllegalAccessException, InstantiationException {
        CacheKey cacheKey = new CacheKey(new Object[]{sql, parms, clazz});
        if (this.cache.getObject(cacheKey) != null) {
            return (List)this.cache.getObject(cacheKey);
        }
        List list = this.baseExecutor.doQuery(sql, parms, clazz);
        this.cache.putObject(cacheKey, list);
        return list;
    }

    @Override
    public int updateBySQL(String sql, Object parms) {
        int count = this.baseExecutor.updateBySQL(sql, parms);
        if (count > 0) {
            this.cache.clear();
        }
        return count;
    }

    @Override
    public Object insertBySQL(String sql, Object parms) {
        Object object = this.baseExecutor.insertBySQL(sql, parms);
        if (object != null) {
            this.cache.clear();
        }
        return object;
    }

    @Override
    public List Query(String sql, Object parms) {
        CacheKey cacheKey = new CacheKey(new Object[]{sql, parms});
        if (this.cache.getObject(cacheKey) != null) {
            return (List)this.cache.getObject(cacheKey);
        }
        List list = this.baseExecutor.Query(sql, parms);
        this.cache.putObject(cacheKey, list);
        return list;
    }

    @Override
    public void close() throws IOException {
    }
}

