/*
 * Decompiled with CFR 0.152.
 */
package cn.com.louie.cache;

import cn.com.louie.cache.Cache;
import java.util.concurrent.locks.ReadWriteLock;

public class TimerCache
implements Cache {
    private Cache delegate;
    protected long clearInterval;
    protected long lastClear;

    public TimerCache(Cache delegate, long clearInterval) {
        this.delegate = delegate;
        this.clearInterval = clearInterval;
        this.lastClear = System.currentTimeMillis();
    }

    public void setClearInterval(long clearInterval) {
        this.clearInterval = clearInterval;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        this.clearWhenStale();
        return this.delegate.getSize();
    }

    @Override
    public void putObject(Object key, Object object) {
        this.clearWhenStale();
        this.lastClear = System.currentTimeMillis();
        this.delegate.putObject(key, object);
    }

    @Override
    public Object getObject(Object key) {
        if (this.clearWhenStale()) {
            return null;
        }
        return this.delegate.getObject(key);
    }

    @Override
    public Object removeObject(Object key) {
        this.clearWhenStale();
        return this.delegate.removeObject(key);
    }

    @Override
    public void clear() {
        this.lastClear = System.currentTimeMillis();
        this.delegate.clear();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return null;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    private boolean clearWhenStale() {
        if (System.currentTimeMillis() - this.lastClear > this.clearInterval) {
            this.clear();
            return true;
        }
        return false;
    }
}

