/*
 * Decompiled with CFR 0.152.
 */
package com.louie.mapper;

import com.louie.mapper.BaseEO;
import com.louie.mapper.Column;
import com.louie.mapper.Generate;
import com.louie.mapper.Id;
import com.louie.mapper.QType;
import com.louie.mapper.Table;
import com.louie.mapper.Transient;
import com.mysql.jdbc.StringUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EOUtility {
    public transient BaseEO bean;
    private PropertyDescriptor[] propertyDescriptors;
    private Class<? extends BaseEO> clazz;
    private Map<String, Method> getter;
    private Map<String, Method> setter;
    private Map<String, QType> colums;
    private String insertSQL;
    private String tableName;
    private String primaryKey;
    private String updateSQL;
    private String selectSQL;

    public EOUtility(BaseEO bean) {
        try {
            this.init(bean);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void init(BaseEO bean) throws IllegalAccessException, InstantiationException {
        if (this.bean != bean) {
            this.bean = bean;
            this.clazz = this.bean.getClass();
            this.getter = new HashMap<String, Method>();
            this.setter = new HashMap<String, Method>();
            this.colums = null;
            this.insertSQL = null;
            this.tableName = null;
            this.primaryKey = null;
            this.selectSQL = null;
            try {
                this.propertyDescriptors = Introspector.getBeanInfo(this.clazz).getPropertyDescriptors();
            }
            catch (IntrospectionException var3) {
                var3.printStackTrace();
            }
            this.getColums();
            this.gettableName();
        }
    }

    public String gettableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        Table table = this.clazz.getAnnotation(Table.class);
        this.tableName = table != null && !StringUtils.isNullOrEmpty((String)table.name()) ? table.name() : this.clazz.getSimpleName();
        return this.tableName;
    }

    public String buildSelect(String whereSQL) {
        String slsql;
        StringBuffer select = new StringBuffer("SELECT ");
        for (Map.Entry<String, QType> entry : this.getColums().entrySet()) {
            select.append(entry.getValue().getKey() + ", ");
        }
        String string = slsql = select.toString().indexOf(",") == -1 ? null : select.toString().substring(0, select.toString().lastIndexOf(","));
        if (slsql == null) {
            throw new IllegalArgumentException("beans must have an attr");
        }
        this.selectSQL = StringUtils.isNullOrEmpty((String)whereSQL) ? slsql + " FROM " + this.gettableName() : slsql + " FROM " + this.gettableName() + " WHERE " + whereSQL;
        return this.selectSQL;
    }

    public Map<String, QType> getColums() {
        Field[] fields;
        if (this.colums != null) {
            return this.colums;
        }
        this.colums = new HashMap<String, QType>();
        Field[] arr$ = fields = this.clazz.getDeclaredFields();
        int len$ = fields.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field = arr$[i$];
            if (field.getAnnotation(Id.class) != null) {
                this.primaryKey = field.getName();
            }
            if (this.isLazyField(field.getDeclaredAnnotations())) continue;
            this.colums.put(field.getName(), this.getColumn(field.getName()));
            for (PropertyDescriptor property : this.propertyDescriptors) {
                if (!field.getName().toLowerCase().equals(property.getName().toLowerCase())) continue;
                this.setter.put(field.getName(), property.getWriteMethod());
                this.getter.put(field.getName(), property.getReadMethod());
            }
        }
        return this.colums;
    }

    public void setAttributeValue(String attName, Object value) {
        try {
            Method m = this.setter.get(attName);
            m.invoke((Object)this.bean, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isGenerate(String field) {
        try {
            return this.clazz.getDeclaredField(field).getAnnotation(Generate.class) == null;
        }
        catch (NoSuchFieldException var3) {
            return true;
        }
    }

    public String buildInsert() {
        Map<String, QType> filds = this.getColums();
        StringBuffer insert = new StringBuffer("INSERT INTO " + this.gettableName() + "(");
        StringBuffer values = new StringBuffer(" VALUES (");
        Iterator<Map.Entry<String, QType>> val = filds.entrySet().iterator();
        while (true) {
            if (!val.hasNext()) {
                val = null;
                if (!values.toString().contains(",")) {
                    throw new IllegalArgumentException("insert must have an attr value");
                }
                String val1 = values.toString();
                val1 = val1.substring(0, val1.length() - 1);
                String ins1 = insert.toString();
                ins1 = ins1.substring(0, ins1.length() - 1);
                this.insertSQL = ins1 + ")" + val1 + ")";
                return this.insertSQL;
            }
            Map.Entry<String, QType> ins = val.next();
            if (this.getAttributeValue(ins.getKey()) == null || !this.isGenerate(ins.getKey())) continue;
            insert.append(ins.getValue().getKey() + ",");
            if (!this.isDigital(ins.getValue().getType())) {
                values.append("'" + this.getAttributeValue(ins.getKey()).toString().replaceAll("'", "\\\\'") + "',");
                continue;
            }
            values.append(this.getAttributeValue(ins.getKey()) + ",");
        }
    }

    public String buildUpdate(String whereSQL) {
        Map<String, QType> filds = this.getColums();
        StringBuffer update = new StringBuffer("UPDATE " + this.gettableName() + " SET ");
        Iterator<Map.Entry<String, QType>> upsql = filds.entrySet().iterator();
        while (true) {
            if (!upsql.hasNext()) {
                String upsql1;
                String string = upsql1 = update.toString().indexOf(",") == -1 ? null : update.toString().substring(0, update.length() - 2);
                if (StringUtils.isNullOrEmpty((String)whereSQL)) {
                    if (this.primaryKey == null) {
                        throw new IllegalArgumentException("update must have an id or WhereSQL");
                    }
                    QType entry1 = filds.get(this.primaryKey);
                    this.updateSQL = !this.isDigital(entry1.getType()) ? upsql1 + " WHERE " + filds.get(this.primaryKey).getKey() + "='" + this.getAttributeValue(this.primaryKey) + "'" : upsql1 + " WHERE " + filds.get(this.primaryKey).getKey() + "=" + this.getAttributeValue(this.primaryKey);
                } else {
                    this.updateSQL = upsql1 + " WHERE " + whereSQL;
                }
                return this.updateSQL;
            }
            Map.Entry<String, QType> entry = upsql.next();
            if (this.getAttributeValue(entry.getKey()) == null || entry.getKey().equals(this.primaryKey)) continue;
            if (!this.isDigital(entry.getValue().getType())) {
                update.append(entry.getValue().getKey() + "='" + this.getAttributeValue(entry.getKey()).toString().replaceAll("'", "\\\\'") + "', ");
                continue;
            }
            update.append(entry.getValue().getKey() + "=" + this.getAttributeValue(entry.getKey()) + ", ");
        }
    }

    private boolean isDigital(Type qType) {
        return qType.equals(Integer.class) || qType.equals(Short.class) || qType.equals(Long.class) || qType.equals(Double.class) || qType.equals(Float.class) || qType.equals(Byte.class) || qType.equals(Byte.TYPE) || qType.equals(Integer.TYPE) || qType.equals(Short.TYPE) || qType.equals(Long.TYPE) || qType.equals(Double.TYPE) || qType.equals(Float.TYPE);
    }

    public Object getAttributeValue(String attName) {
        Object o = null;
        try {
            Object os = null;
            Method m = this.getter.get(attName);
            o = m.invoke((Object)this.bean, (Object[])os);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public QType getColumn(String fieldName) {
        Field f;
        String column = null;
        try {
            f = this.clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException var6) {
            return null;
        }
        catch (NoSuchFieldException var7) {
            return null;
        }
        Column am = f.getAnnotation(Column.class);
        column = am != null && !StringUtils.isNullOrEmpty((String)am.name()) ? am.name() : fieldName;
        QType qType = new QType(column, f.getGenericType());
        return qType;
    }

    public boolean isLazyField(Annotation[] annotations) {
        Annotation[] arr$ = annotations;
        int len$ = annotations.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation annotation = arr$[i$];
            if (!(annotation instanceof Transient)) continue;
            return true;
        }
        return false;
    }
}

