/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.xa;

import com.kingbase8.KBConnection;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.TransactionState;
import com.kingbase8.ds.KBPooledConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import com.kingbase8.xa.KBXAException;
import com.kingbase8.xa.RecoveredXid;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class KBXAConnection
extends KBPooledConnection
implements XAConnection,
XAResource {
    private final BaseConnection _conn;
    private Xid currentXid;
    private EState stateT;
    private Xid preparedXid;
    private boolean committedOrRolledBackT;
    private boolean localAutoCommitMode = true;

    private void debug_(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            KBLOGGER.log(Level.FINEST, "XAResource {0}: {1}", Integer.toHexString(this.hashCode()), str);
        }
    }

    public KBXAConnection(BaseConnection _conn) throws SQLException {
        super(_conn, true, true);
        this._conn = _conn;
        this.stateT = EState.IN_IDLE;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Connection _conn = super.getConnection();
        if (this.stateT == EState.IN_IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _conn.setAutoCommit(true);
        }
        ConnectionHandler _handler = new ConnectionHandler(_conn);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, KBConnection.class}, (InvocationHandler)_handler);
    }

    @Override
    public XAResource getXAResource() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this;
    }

    @Override
    public void start(Xid _xid, int _flags) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.debug_("starting transaction _xid = " + _xid);
        }
        if (_flags != 0 && _flags != 0x8000000 && _flags != 0x200000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Invalid _flags {0}", _flags), -5);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_xid == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("_xid must not be null", new Object[0]), -5);
        }
        if (this.stateT == EState.IN_ACTIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Connection is busy with another transaction", new Object[0]), -6);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flags == 0x8000000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("suspend/resume not implemented", new Object[0]), -3);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flags == 0x200000) {
            if (this.stateT != EState.IN_ENDED) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Invalid protocol state requested. Attempted transaction interleaving is not supported. _xid={0}, currentXid={1}, state={2}, _flags={3}", new Object[]{_xid, this.currentXid, this.stateT, _flags}), -3);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!_xid.equals(this.currentXid)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Invalid protocol state requested. Attempted transaction interleaving is not supported. _xid={0}, currentXid={1}, state={2}, _flags={3}", new Object[]{_xid, this.currentXid, this.stateT, _flags}), -3);
            }
        } else if (this.stateT == EState.IN_ENDED) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Invalid protocol state requested.-- Attempted transaction interleaving is not supported. _xid={0}, currentXid={1}, stateT={2}, _flags={3}", new Object[]{_xid, this.currentXid, this.stateT, _flags}), -3);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flags == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.localAutoCommitMode = this._conn.getAutoCommit();
                this._conn.setAutoCommit(false);
            }
            catch (SQLException ex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Error disabling autocommit", new Object[0]), ex, -3);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stateT = EState.IN_ACTIVE;
        this.currentXid = _xid;
        this.preparedXid = null;
        this.committedOrRolledBackT = false;
    }

    @Override
    public void end(Xid _xid, int _flags) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            this.debug_("ending transaction _xid = " + _xid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flags != 0x2000000 && _flags != 0x20000000 && _flags != 0x4000000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Invalid _flags {0}", _flags), -5);
        }
        if (_xid == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("_xid must not be null", new Object[0]), -5);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.stateT != EState.IN_ACTIVE || !this.currentXid.equals(_xid)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("tried to call end without corresponding start call. state={0}, start _xid={1}, currentXid={2}, preparedXid={3}", new Object[]{this.stateT, _xid, this.currentXid, this.preparedXid}), -6);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flags == 0x2000000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("suspend/resume not implemented", new Object[0]), -3);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stateT = EState.IN_ENDED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid _xid) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            this.debug_("preparing transaction _xid = " + _xid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.currentXid == null && this.preparedXid != null) {
            if (KBLOGGER.isLoggable(Level.FINEST)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.debug_("Prepare _xid " + _xid + " but current _connection is not attached to a transaction" + " while it was prepared in past with prepared _xid " + this.preparedXid);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Preparing already prepared transaction, the prepared _xid {0}, prepare _xid={1}", this.preparedXid, _xid), -6);
        }
        if (this.currentXid == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Current _connection does not have an associated _xid. prepare _xid={0}", _xid), -4);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.currentXid.equals(_xid)) {
            if (KBLOGGER.isLoggable(Level.FINEST)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.debug_("Error to prepare _xid " + _xid + ", the current _connection already bound with _xid " + this.currentXid);
            }
            throw new KBXAException(GT.tr("Not implemented: Prepare must be issued using the same _connection that started the transaction. currentXid={0}, prepare _xid={1}", this.currentXid, _xid), -3);
        }
        if (this.stateT != EState.IN_ENDED) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Prepare called before end. prepare _xid={0}, state={1}", _xid), -5);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stateT = EState.IN_IDLE;
        this.preparedXid = this.currentXid;
        this.currentXid = null;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = RecoveredXid._xidToString(_xid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Statement stm = this._conn.createStatement();
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stm.executeUpdate("PREPARE TRANSACTION '" + s + "'");
            }
            finally {
                stm.close();
            }
            this._conn.setAutoCommit(this.localAutoCommitMode);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        catch (SQLException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Error preparing transaction. prepare _xid={0}", _xid), ex, this.mapSQLStateToXAErrorCode(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int _flag) throws XAException {
        Xid[] xidArray;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_flag != 0x1000000 && _flag != 0x800000 && _flag != 0 && _flag != 0x1800000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Invalid _flags {0}", _flag), -5);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((_flag & 0x1000000) == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Xid[0];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = this._conn.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = stm.executeQuery("SELECT gid FROM pg_prepared_xacts where database = current_database()");
            LinkedList<Xid> l = new LinkedList<Xid>();
            while (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Xid recoveredXid = RecoveredXid.stringToXid(resultSet.getString(1));
                if (recoveredXid == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                l.add(recoveredXid);
            }
            resultSet.close();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            xidArray = l.toArray(new Xid[0]);
        }
        catch (Throwable throwable) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (resultSet != null) {
                    resultSet.close();
                }
                stm.close();
                throw throwable;
            }
            catch (SQLException ex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Error during recover", new Object[0]), ex, -3);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (resultSet != null) {
            resultSet.close();
        }
        stm.close();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid _xid) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.debug_("rolling back _xid = " + _xid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.currentXid != null && this.currentXid.equals(_xid)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.stateT = EState.IN_IDLE;
                this.currentXid = null;
                this._conn.rollback();
                this._conn.setAutoCommit(this.localAutoCommitMode);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String s = RecoveredXid._xidToString(_xid);
                this._conn.setAutoCommit(true);
                Statement stm = this._conn.createStatement();
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    stm.executeUpdate("ROLLBACK PREPARED '" + s + "'");
                }
                finally {
                    stm.close();
                }
            }
            this.committedOrRolledBackT = true;
        }
        catch (SQLException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int errorCodeT = -3;
            if (KSQLState.UNDEFINED_OBJECT.getState().equals(ex.getSQLState()) && (this.committedOrRolledBackT || !_xid.equals(this.preparedXid))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (KBLOGGER.isLoggable(Level.FINEST)) {
                    this.debug_("rolling back _xid " + _xid + " while the _connection prepared _xid is " + this.preparedXid + (this.committedOrRolledBackT ? ", but the _connection was already committed/rolled-back" : ""));
                }
                errorCodeT = -4;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KSQLState.isConnectionError(ex.getSQLState())) {
                if (KBLOGGER.isLoggable(Level.FINEST)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.debug_("rollback _connection failure (_sql _error code " + ex.getSQLState() + "), re_connection could be expected");
                }
                errorCodeT = -7;
            }
            throw new KBXAException(GT.tr("Error rolling back prepared transaction.-- rollback _xid={0}, preparedXid={1}, currentXid={2}", _xid, this.preparedXid), ex, errorCodeT);
        }
    }

    @Override
    public void commit(Xid _xid, boolean onePhase) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.debug_("committing _xid = " + _xid + (onePhase ? " (one phase) " : " (two phase)"));
        }
        if (_xid == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("_xid must not be null", new Object[0]), -5);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (onePhase) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.commitOnePhase(_xid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.commitPrepared(_xid);
        }
    }

    private void commitOnePhase(Xid _xid) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (_xid.equals(this.preparedXid)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("One-phase commit called for _xid {0} but _connection was prepared with _xid {1}", _xid, this.preparedXid), -6);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.currentXid == null && !this.committedOrRolledBackT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Not implemented: one-phase commit must be issued using the same _connection that was used to start it", _xid), -3);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!_xid.equals(this.currentXid) || this.committedOrRolledBackT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("One-phase commit with unknown _xid. commit _xid={0}, currentXid={1}", _xid, this.currentXid), -4);
            }
            if (this.stateT != EState.IN_ENDED) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("commit called before end. commit _xid={0}, state={1}", new Object[]{_xid, this.stateT}), -6);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.stateT = EState.IN_IDLE;
            this.currentXid = null;
            this.committedOrRolledBackT = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._conn.commit();
            this._conn.setAutoCommit(this.localAutoCommitMode);
        }
        catch (SQLException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBXAException(GT.tr("Error during one-phase commit. commit _xid={0}", _xid), ex, this.mapSQLStateToXAErrorCode(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPrepared(Xid _xid) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.stateT != EState.IN_IDLE || this._conn.getTransactionState() != TransactionState.IDLE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KBXAException(GT.tr("Not implemented:-- 2nd phase commit must be issued using an idle _connection. commit _xid={0}, currentXid={1}, state={2}, transactionState={3}", new Object[]{_xid, this.currentXid, this.stateT, this._conn.getTransactionState()}), -3);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = RecoveredXid._xidToString(_xid);
            this.localAutoCommitMode = this._conn.getAutoCommit();
            this._conn.setAutoCommit(true);
            Statement stm = this._conn.createStatement();
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stm.executeUpdate("COMMIT PREPARED '" + s + "'");
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stm.close();
                this._conn.setAutoCommit(this.localAutoCommitMode);
            }
            this.committedOrRolledBackT = true;
        }
        catch (SQLException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int errorCodeT = -3;
            if (KSQLState.UNDEFINED_OBJECT.getState().equals(ex.getSQLState()) && (this.committedOrRolledBackT || !_xid.equals(this.preparedXid))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (KBLOGGER.isLoggable(Level.FINEST)) {
                    this.debug_("committing _xid " + _xid + " while the _connection prepared _xid is " + this.preparedXid + (this.committedOrRolledBackT ? ", but the _connection was already committed/rolled-back" : ""));
                }
                errorCodeT = -4;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KSQLState.isConnectionError(ex.getSQLState())) {
                if (KBLOGGER.isLoggable(Level.FINEST)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.debug_("commit _connection failure (_sql _error code " + ex.getSQLState() + "), re_connection could be expected");
                }
                errorCodeT = -7;
            }
            throw new KBXAException(GT.tr("Error committing prepared transaction.-- commit _xid={0}, preparedXid={1}, currentXid={2}", _xid, this.preparedXid, this.currentXid), ex, errorCodeT);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return xaResource == this;
    }

    @Override
    public void forget(Xid _xid) throws XAException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KBXAException(GT.tr("Heuristic commit/rollback not supported.-- forget _xid={0}", _xid), -4);
    }

    @Override
    public int getTransactionTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int secondsTime) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    private int mapSQLStateToXAErrorCode(SQLException _sqlException) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isKingbase8IntegrityConstraintViolation(_sqlException)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 103;
        }
        return -7;
    }

    private boolean isKingbase8IntegrityConstraintViolation(SQLException _sqlException) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _sqlException instanceof KSQLException && _sqlException.getSQLState().length() == 5 && _sqlException.getSQLState().startsWith("23");
    }

    private static enum EState {
        IN_IDLE,
        IN_ACTIVE,
        IN_ENDED;

    }

    private class ConnectionHandler
    implements InvocationHandler {
        private final Connection _con;

        ConnectionHandler(Connection _con) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._con = _con;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] argsObject) throws Throwable {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KBXAConnection.this.stateT != EState.IN_IDLE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String mtdName = mtd.getName();
                if (mtdName.equals("commit") || mtdName.equals("rollback") || mtdName.equals("setSavePoint") || mtdName.equals("setAutoCommit") && ((Boolean)argsObject[0]).booleanValue()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("Transaction control mtds setAutoCommit(true), commit, rollback and setSavePoint not allowed while an XA transaction \u662f\u5426\u5b58\u6d3b.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
                }
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (mtd.getName().equals("equals") && argsObject.length == 1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Object argObject = argsObject[0];
                    if (argObject != null && Proxy.isProxyClass(argObject.getClass())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        InvocationHandler invocationHandler = Proxy.getInvocationHandler(argObject);
                        if (invocationHandler instanceof ConnectionHandler) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            argsObject = new Object[]{((ConnectionHandler)invocationHandler)._con};
                        }
                    }
                }
                return mtd.invoke((Object)this._con, argsObject);
            }
            catch (InvocationTargetException invocationTargetException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

