/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.jdbc.AbstractTypeInfoCache;
import com.kingbase8.jdbc.TypeInfoCache;
import java.util.HashMap;

public class MysqlTypeInfoCache
extends AbstractTypeInfoCache {
    private static final Object[][] typesT = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"timestamp", 1184, 93, "java.sql.Timestamp", 1185}, {"json", 114, 1111, "com.kingbase8.util.KBobject", 199}, {"point", 600, 1111, "com.kingbase8.geometric.KBpoint", 1017}, {"smallint", 21, 5, "java.lang.Integer", 1005}, {"int", 23, 4, "java.lang.Integer", 1007}, {"bigint", 20, -5, "java.lang.Long", 1016}, {"float", 700, 7, "java.lang.Float", 1021}, {"double", 701, 8, "java.lang.Double", 1022}, {"char", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"blob", 17, -4, "[B", 1001}, {"bit", 16, -7, "java.lang.Boolean", 1000}, {"bit", 4655, -7, "java.lang.Boolean", 4656}, {"int unsigned", 7082, 4, "java.lang.Long", 7083}, {"bigint unsigned", 7084, -5, "java.math.BigInteger", 7085}, {"tinyint", 7014, -6, "java.lang.Integer", -1}, {"tinyint", 8100, -6, "java.lang.Integer", 8101}, {"mediumint", 7016, 4, "java.lang.Integer", -1}, {"mediumint", 7017, 4, "java.lang.Integer", -1}, {"mediumint", 7015, 4, "java.lang.Integer", -1}, {"decimal", 1700, 3, "java.math.BigDecimal", -1}, {"longtext", 7018, -1, "java.lang.String", -1}, {"mediumtext", 7019, -1, "java.lang.String", -1}, {"tinytext", 7020, 12, "java.lang.String", -1}, {"text", 25, -1, "java.lang.String", 1009}, {"binary", 3383, -2, "[B", 3385}, {"varbinary", 3384, -3, "[B", 3386}, {"blob", 8013, -4, "[B", -1}, {"tinyblob", 7023, -3, "[B", -1}, {"mediumblob", 7022, -4, "[B", -1}, {"longblob", 7021, -4, "[B", -1}, {"date", 7944, 91, "java.sql.Date", -1}, {"time", 7950, 92, "java.sql.Time", 7951}, {"datetime", 7952, 93, "java.sql.Timestamp", 7953}, {"timestamp", 7954, 93, "java.sql.Timestamp", 7955}, {"year", 7024, 91, "java.sql.Date", -1}, {"clob", 8014, 2005, "java.sql.Clob", -1}, {"nclob", 8015, 2011, "java.sql.NClob", -1}, {"bpcharbyte", 8016, 1, "java.lang.String", 8017}, {"varcharbyte", 8018, 12, "java.lang.String", 8019}, {"rowid", 6123, -8, "com.kingbase8.jdbc.KbRowId", 6124}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public MysqlTypeInfoCache(TypeInfoCache typeInfoCache, BaseConnection baseConnection) {
        super(typeInfoCache, baseConnection);
    }

    @Override
    public Object[][] getTypes() {
        return typesT;
    }

    @Override
    public HashMap<String, String> getTypeAliases() {
        return typeAliases;
    }

    @Override
    public int getPrecision(int oidT, int typemodT, BaseConnection baseConnection) {
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 7014: 
            case 8100: {
                return 3;
            }
            case 21: {
                return 5;
            }
            case 7015: 
            case 7016: 
            case 7017: {
                return 7;
            }
            case 23: 
            case 26: 
            case 7082: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 7084: {
                return 20;
            }
            case 700: {
                return 12;
            }
            case 701: {
                return 22;
            }
            case 1700: {
                if (typemodT == -1) {
                    return 10;
                }
                return (typemodT - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: 
            case 3383: 
            case 3384: 
            case 8016: 
            case 8018: {
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 7024: 
            case 7944: 
            case 7950: 
            case 7952: 
            case 7954: 
            case 8020: {
                return this.getDisplaySize(oidT, typemodT, baseConnection);
            }
            case 1560: 
            case 4655: {
                return typemodT;
            }
            case 1562: {
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT;
            }
            case 27: {
                return 18;
            }
            case 6123: {
                return 23;
            }
            case 7018: {
                return Integer.MAX_VALUE;
            }
            case 7019: {
                return 0xFFFFFF;
            }
            case 7020: {
                return 255;
            }
            case 25: {
                return 65535;
            }
            case 8013: {
                return 65535;
            }
            case 7023: {
                return 255;
            }
            case 7022: {
                return 0xFFFFFF;
            }
            case 7021: {
                return Integer.MAX_VALUE;
            }
            case 17: {
                return 65535;
            }
        }
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getDisplaySize(int oidT, int typemodT, BaseConnection baseConnection) {
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 7014: 
            case 8100: {
                return 3;
            }
            case 21: {
                return 5;
            }
            case 7015: 
            case 7016: 
            case 7017: {
                return 7;
            }
            case 23: 
            case 7082: {
                return 10;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 7084: {
                return 20;
            }
            case 700: {
                return 12;
            }
            case 701: {
                return 22;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 7024: {
                return 4;
            }
            case 1082: 
            case 7944: {
                return 10;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 7950: 
            case 7952: 
            case 7954: 
            case 8020: {
                int secondSizeT;
                switch (typemodT) {
                    case -1: {
                        secondSizeT = 0;
                        break;
                    }
                    case 0: {
                        secondSizeT = 0;
                        break;
                    }
                    case 1: {
                        secondSizeT = 2;
                        break;
                    }
                    default: {
                        secondSizeT = typemodT + 1;
                    }
                }
                switch (oidT) {
                    case 1083: 
                    case 7950: {
                        return 8 + secondSizeT;
                    }
                    case 1266: {
                        return 8 + secondSizeT + 6;
                    }
                    case 1114: 
                    case 7952: 
                    case 7954: 
                    case 8020: {
                        return 19 + secondSizeT;
                    }
                    case 1184: {
                        return 19 + secondSizeT;
                    }
                }
                return 19 + secondSizeT;
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: 
            case 3383: 
            case 3384: 
            case 8016: 
            case 8018: {
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT - 4;
            }
            case 1700: {
                if (typemodT == -1) {
                    return 10;
                }
                int precision = typemodT - 4 >> 16 & 0xFFFF;
                int scale = typemodT - 4 & 0xFFFF;
                return precision;
            }
            case 1560: 
            case 4655: {
                return typemodT;
            }
            case 1562: {
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT;
            }
            case 7018: {
                return Integer.MAX_VALUE;
            }
            case 7019: {
                return 0xFFFFFF;
            }
            case 7020: {
                return 255;
            }
            case 25: {
                return 65535;
            }
            case 8013: {
                return 65535;
            }
            case 7023: {
                return 255;
            }
            case 7022: {
                return 0xFFFFFF;
            }
            case 7021: {
                return Integer.MAX_VALUE;
            }
            case 17: {
                return 65535;
            }
            case 27: {
                return 18;
            }
            case 6123: {
                return 23;
            }
        }
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getScale(int oidT, int typemodT, BaseConnection baseConnection) {
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 700: {
                return 0;
            }
            case 701: {
                return 0;
            }
            case 7024: {
                return 0;
            }
            case 1700: {
                if (typemodT == -1) {
                    return 0;
                }
                return typemodT - 4 & 0xFFFF;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 7944: 
            case 7950: 
            case 7952: 
            case 7954: {
                if (typemodT == -1) {
                    return 0;
                }
                return typemodT;
            }
            case 1186: {
                if (typemodT == -1) {
                    return 6;
                }
                return typemodT & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public int getColumnSize(int oidT, int typemodT, BaseConnection baseConnection) {
        return this.getPrecision(oidT, typemodT, baseConnection);
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("mediumint", "int4");
        typeAliases.put("middleint", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("boolean", "bit");
        typeAliases.put("bool", "bit");
        typeAliases.put("dec", "numeric");
        typeAliases.put("fixed", "numeric");
        typeAliases.put("float", "float8");
        typeAliases.put("decimal", "numeric");
    }
}

