/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds;

import com.kingbase8.ds.KBConnectionPoolDataSource;
import com.kingbase8.ds.common.BaseDataSource;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

@Deprecated
public class KBPoolingDataSource
extends BaseDataSource
implements DataSource {
    protected static ConcurrentMap<String, KBPoolingDataSource> dataSources = new ConcurrentHashMap<String, KBPoolingDataSource>();
    protected String dSName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initializedT = false;
    private Stack<PooledConnection> availStack = new Stack();
    private Stack<PooledConnection> usedStack = new Stack();
    private Object lockObj = new Object();
    private KBConnectionPoolDataSource source;
    private ConnectionEventListener conEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = KBPoolingDataSource.this.lockObj;
            synchronized (object) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (KBPoolingDataSource.this.availStack == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return;
                }
                boolean removed = KBPoolingDataSource.this.usedStack.remove(connectionEvent.getSource());
                if (removed) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBPoolingDataSource.this.availStack.push((PooledConnection)connectionEvent.getSource());
                    KBPoolingDataSource.this.lockObj.notify();
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = KBPoolingDataSource.this.lockObj;
            synchronized (object) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (KBPoolingDataSource.this.availStack == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBPoolingDataSource.this.usedStack.remove(event.getSource());
                KBPoolingDataSource.this.lockObj.notify();
            }
        }
    };

    public static KBPoolingDataSource getDataSource(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (KBPoolingDataSource)dataSources.get(name);
    }

    @Override
    public String getDescription() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "Pooling DataSource '" + this.dSName + " from " + "Kingbase8 JDBC Driver V008R006B0001";
    }

    @Override
    public void setServerName(String serName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        super.setServerName(serName);
    }

    @Override
    public void setDatabaseName(String dbName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        super.setDatabaseName(dbName);
    }

    @Override
    public void setUser(String user) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        super.setUser(user);
    }

    @Override
    public void setPassword(String password) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        super.setPassword(password);
    }

    @Override
    public void setPortNumber(int portNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        super.setPortNumber(portNum);
    }

    public int getInitialConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.initialConnections;
    }

    public void setInitialConnections(int initialConnectionsT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException(" Cannot set Data Source propes after DataSource has been used");
        }
        this.initialConnections = initialConnectionsT;
    }

    public int getMaxConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        this.maxConnections = maxConnections;
    }

    public String getDataSourceName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.dSName;
    }

    public void setDataSourceName(String dSName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot set Data Source propes after DataSource has been used");
        }
        if (this.dSName != null && dSName != null && dSName.equals(this.dSName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        KBPoolingDataSource previous = dataSources.putIfAbsent(dSName, this);
        if (previous != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("DataSource with name '" + dSName + "' already exists!");
        }
        if (this.dSName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dataSources.remove(this.dSName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dSName = dSName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object object = this.lockObj;
        synchronized (object) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.source = this.createConnectionPool();
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.source.initializeFrom(this);
            }
            catch (Exception e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Failed to setup DataSource.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (this.availStack.size() < this.initialConnections) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.availStack.push(this.source.getPooledConnection());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.initializedT = true;
        }
    }

    protected boolean isInitialized() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.initializedT;
    }

    protected KBConnectionPoolDataSource createConnectionPool() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KBConnectionPoolDataSource();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (user == null || user.equals(this.getUser()) && (password == null && this.getPassword() == null || password != null && password.equals(this.getPassword()))) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getConnection();
        }
        if (!this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.initialize();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return super.getConnection(user, password);
    }

    @Override
    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.initializedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.initialize();
        }
        return this.getPooledConnection_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object object = this.lockObj;
        synchronized (object) {
            PooledConnection pooledConni;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (!this.availStack.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pooledConni = this.availStack.pop();
                try {
                    pooledConni.close();
                }
                catch (SQLException sqlException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
            this.availStack = null;
            while (!this.usedStack.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pooledConni = this.usedStack.pop();
                pooledConni.removeConnectionEventListener(this.conEventListener);
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pooledConni.close();
                }
                catch (SQLException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.usedStack = null;
        }
        this.removeStoredDataSource();
    }

    protected void removeStoredDataSource() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        dataSources.remove(this.dSName);
    }

    protected void addDataSource(String dSName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        dataSources.put(dSName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PooledConnection pooledConn = null;
        Object object = this.lockObj;
        synchronized (object) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.availStack == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("DataSource has been closed.", new Object[0]), KSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            while (true) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!this.availStack.isEmpty()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pooledConn = this.availStack.pop();
                    this.usedStack.push(pooledConn);
                    break;
                }
                if (this.maxConnections == 0 || this.usedStack.size() < this.maxConnections) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pooledConn = this.source.getPooledConnection();
                    this.usedStack.push(pooledConn);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    this.lockObj.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!Thread.interrupted()) continue;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        pooledConn.addConnectionEventListener(this.conEventListener);
        return pooledConn.getConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("dSName", this.dSName));
        if (this.initialConnections > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return reference;
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return clz.isAssignableFrom(this.getClass());
    }
}

