/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.executor.AbstractExecuteCommand;
import com.kingbase8.dispatcher.executor.DispatchStatementV2;
import com.kingbase8.dispatcher.executor.command.PrepareStCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStIncreaseCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStIndexCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStNamesCommand;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DispatchPreparedStatementV2
extends DispatchStatementV2
implements PreparedStatement {
    public DispatchPreparedStatementV2(DispatchConnection _conn) {
        super(_conn);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStCommand(_sql);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStCommand(_sql, _resultSetType, _resultSetHoldability);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql, int _resultSetType, int _resultSetConcurrency) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStCommand(_sql, _resultSetType, _resultSetConcurrency);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql, int autoGeneratedKeys) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStIncreaseCommand(_sql, autoGeneratedKeys);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql, String[] _columnNames) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStNamesCommand(_sql, _columnNames);
    }

    public DispatchPreparedStatementV2(DispatchConnection _conn, String _sql, int[] _columnIndexes) {
        super(_conn);
        this.dispatchType = this.getExecuteType(_sql);
        this.createCommand = new PrepareStIndexCommand(_sql, _columnIndexes);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeQuery()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                KbResultSet brs;
                BaseConnection _conn = (BaseConnection)t.getConnection();
                ResultSet resultSet = ((PreparedStatement)t).executeQuery();
                if (_conn.isSlave() && _conn.isZeroResend() && (brs = (KbResultSet)resultSet).getTupleCount() == 0) {
                    resultSet.close();
                    throw new KSQLException("_resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return resultSet;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeUpdate()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).executeUpdate();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).executeBatch();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int _parameterIndex, final int _sqlType) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + _parameterIndex + "," + _sqlType + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNull(_parameterIndex, _sqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBoolean(final int _parameterIndex, final boolean x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBoolean(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBoolean(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setByte(final int _parameterIndex, final byte x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setByte(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setByte(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setShort(final int _parameterIndex, final short x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setShort(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setShort(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setInt(final int _parameterIndex, final int x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setInt(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setInt(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setLong(final int _parameterIndex, final long x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setLong(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setLong(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFloat(final int _parameterIndex, final float x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setFloat(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setFloat(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDouble(final int _parameterIndex, final double x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDouble(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDouble(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBigDecimal(final int _parameterIndex, final BigDecimal x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBigDecimal(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBigDecimal(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setString(final int _parameterIndex, final String x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setString(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setString(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBytes(final int _parameterIndex, final byte[] x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBytes(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBytes(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int _parameterIndex, final Date x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDate(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDate(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int _parameterIndex, final Time x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTime(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int _parameterIndex, final Timestamp x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTimestamp(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int _parameterIndex, final InputStream x, final int length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setAsciiStream(_parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setUnicodeStream(final int _parameterIndex, final InputStream x, final int length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setUnicodeStream(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setUnicodeStream(_parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int _parameterIndex, final InputStream x, final int length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBinaryStream(_parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearParameters() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.clearParameters()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).clearParameters();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int _parameterIndex, final Object x, final int targetSqlType, final int scale) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(_parameterIndex, x, targetSqlType, scale);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int _parameterIndex, final Object x, final int targetSqlType) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(_parameterIndex, x, targetSqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int _parameterIndex, final Object x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){
            KbResultSet brs = null;

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.execute()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                BaseConnection _conn = (BaseConnection)t.getConnection();
                Boolean _result = ((PreparedStatement)t).execute();
                if (_conn.isSlave() && _conn.isZeroResend() && _result.booleanValue()) {
                    this.brs = (KbResultSet)t.getResultSet();
                    if (this.brs.getTupleCount() == 0) {
                        this.brs.close();
                        throw new KSQLException("_resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                    }
                }
                return _result;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.addBatch()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                ((PreparedStatement)t).addBatch();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
        this.add(1);
    }

    @Override
    public void setCharacterStream(final int _parameterIndex, final Reader reader, final int length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + _parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setCharacterStream(_parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setRef(final int i, final Ref x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setRef(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setRef(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int i, final Blob x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int i, final Clob x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setArray(final int i, final Array x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setArray(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<ResultSetMetaData> ec = new AbstractExecuteCommand<ResultSetMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getMetaData()";
            }

            @Override
            public ResultSetMetaData execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).getMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int _parameterIndex, final Date x, final Calendar calendar) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDate(_parameterIndex, x, calendar);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int _parameterIndex, final Time x, final Calendar calendar) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTime(_parameterIndex, x, calendar);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int _parameterIndex, final Timestamp x, final Calendar calendar) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTimestamp(_parameterIndex, x, calendar);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int _paramIndex, final int _sqlType, final String typeName) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + _paramIndex + "," + _sqlType + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNull(_paramIndex, _sqlType, typeName);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setURL(final int _parameterIndex, final URL x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setURL(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setURL(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<ParameterMetaData> ec = new AbstractExecuteCommand<ParameterMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getParameterMetaData()";
            }

            @Override
            public ParameterMetaData execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).getParameterMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected boolean expectionHandler(SQLException e, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e)) {
            return true;
        }
        return changeSuccess;
    }

    @Override
    public void setRowId(final int _parameterIndex, final RowId x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setRowId(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setRowId(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNString(final int _parameterIndex, final String _value) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNString(" + _parameterIndex + "," + _value + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNString(_parameterIndex, _value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNCharacterStream(final int _parameterIndex, final Reader _value, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNCharacterStream(" + _parameterIndex + "," + _value + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNCharacterStream(_parameterIndex, _value, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int _parameterIndex, final NClob _value) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + _parameterIndex + "," + _value + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNClob(_parameterIndex, _value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int _parameterIndex, final Reader reader, final long length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + _parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(_parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int _parameterIndex, final InputStream inputStream, final long length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + _parameterIndex + "," + inputStream + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(_parameterIndex, inputStream, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int _parameterIndex, final Reader reader, final long length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + _parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNClob(_parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setSQLXML(final int _parameterIndex, final SQLXML xmlObject) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setSQLXML(" + _parameterIndex + "," + xmlObject + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setSQLXML(_parameterIndex, xmlObject);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int _parameterIndex, final InputStream x, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + _parameterIndex + "," + x + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setAsciiStream(_parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int _parameterIndex, final InputStream x, final long length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + _parameterIndex + "," + x + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBinaryStream(_parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setCharacterStream(final int _parameterIndex, final Reader reader, final long length) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + _parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setCharacterStream(_parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int _parameterIndex, final InputStream x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setAsciiStream(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int _parameterIndex, final InputStream x) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + _parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBinaryStream(_parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setCharacterStream(final int _parameterIndex, final Reader reader) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + _parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setCharacterStream(_parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNCharacterStream(final int _parameterIndex, final Reader _value) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNCharacterStream(" + _parameterIndex + "," + _value + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNCharacterStream(_parameterIndex, _value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int _parameterIndex, final Reader reader) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + _parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(_parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int _parameterIndex, final InputStream inputStream) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + _parameterIndex + "," + inputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(_parameterIndex, inputStream);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int _parameterIndex, final Reader reader) throws SQLException {
        this.checkIsClosed_();
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + _parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNClob(_parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }
}

