/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.KBProperty;
import com.kingbase8.core.ConnectionFactory;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.SetupQueryRunner;
import com.kingbase8.core.SocketFactoryFactory;
import com.kingbase8.core.Utils;
import com.kingbase8.core.Version;
import com.kingbase8.core.v3.QueryExecutorImpl;
import com.kingbase8.fmkey.FmKeyAuthenticator;
import com.kingbase8.gss.MakeGSS;
import com.kingbase8.hostchooser.CandidateHost;
import com.kingbase8.hostchooser.GlobalHostStatusTracker;
import com.kingbase8.hostchooser.HostChooser;
import com.kingbase8.hostchooser.HostChooserFactory;
import com.kingbase8.hostchooser.HostRequirement;
import com.kingbase8.hostchooser.HostStatus;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.ssl.MakeSSL;
import com.kingbase8.sspi.ISSPIClient;
import com.kingbase8.ukpwd.CertAuthenticator;
import com.kingbase8.util.BouncyCastleUtils;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KBByteBuffer;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.MD5Digest;
import com.kingbase8.util.SM3Digest;
import com.kingbase8.util.SM4Utils;
import com.kingbase8.util.ServerErrorMessage;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.net.SocketFactory;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final boolean TRUE = true;
    private static final int AUTH_REQ_OK_T = 0;
    private static final int AUTH_REQ_KRB4_T = 1;
    private static final int AUTH_REQ_KRB5_T = 2;
    private static final int AUTH_REQ_PASSWORD_T = 3;
    private static final int AUTH_REQ_CRYPT_T = 4;
    private static final int AUTH_REQ_MD5_T = 5;
    private static final int AUTH_REQ_SCM_T = 6;
    private static final int AUTH_REQ_GSS_T = 7;
    private static final int AUTH_REQ_GSS_CONTINUE_T = 8;
    private static final int AUTH_REQ_SSPI_T = 9;
    private static final int AUTH_REQ_SASL_T = 10;
    private static final int AUTH_REQ_SASL_CONTINUE_T = 11;
    private static final int AUTH_REQ_SASL_FINAL_T = 12;
    private static final int AUTH_REQ_SM3_T = 13;
    private static final int AUTH_REQ_KCERT_T = 14;
    private static final int AUTH_REQ_SM4_PBKDF2_T = 18;
    private static final int AUTH_REQ_MAC_T = 19;
    private static final int AUTH_REQ_UKCERT_T = 20;

    private ISSPIClient createSSPI(KBStream kbStream, String spnServiceClass, boolean enableNegotiate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class<?> clientClass = Class.forName("com.kingbase8.sspi.SSPIClient");
            return (ISSPIClient)clientClass.getDeclaredConstructor(KBStream.class, String.class, Boolean.TYPE).newInstance(kbStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Unable to load com.kingbase8.sspi.SSPIClient. Please check that SSPIClient is included in your kbjdbc distribution.", exception);
        }
    }

    private KBStream tryConnect(String user, String database, Properties infoProps, SocketFactory socketFactory, HostSpec _hostSpec, SslMode sslMode, int _version, Object cCMV2) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int connectTimeoutT = KBProperty.CONNECT_TIMEOUT.getInt(infoProps) * 1000;
        KBStream newStreamT = new KBStream(socketFactory, _hostSpec, connectTimeoutT, KBProperty.USEDISPATCH.getBoolean(infoProps) && infoProps.getProperty("isMonitor") == null, _version, cCMV2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int socketTimeoutT = KBProperty.SOCKET_TIMEOUT.getInt(infoProps);
        if (KBProperty.USEDISPATCH.getBoolean(infoProps) && infoProps.getProperty("isMonitor") == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (socketTimeoutT < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                socketTimeoutT = 0;
            }
            newStreamT.getSocket().setSoTimeout(1000);
            newStreamT.setSocketTimeout(socketTimeoutT);
            KBLOGGER.log(Level.INFO, "Dispatch : socketTimeout is " + socketTimeoutT * 1000, new Object[0]);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (socketTimeoutT > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setSoTimeout(socketTimeoutT * 1000);
                KBLOGGER.log(Level.INFO, "Single or Monitor : socketTimeout is " + socketTimeoutT * 1000, new Object[0]);
            }
        }
        boolean requireTCPKeepAliveT = KBProperty.TCP_KEEP_ALIVE.getBoolean(infoProps);
        newStreamT.getSocket().setKeepAlive(requireTCPKeepAliveT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int receiveBufferSizeT = KBProperty.RECEIVE_BUFFER_SIZE.getInt(infoProps);
        if (receiveBufferSizeT > -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (receiveBufferSizeT > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setReceiveBufferSize(receiveBufferSizeT);
            } else {
                KBLOGGER.log(Level.WARNING, "Ignore invalid _value for receiveBufferSize: {0}", receiveBufferSizeT);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sendBufferSize = KBProperty.SEND_BUFFER_SIZE.getInt(infoProps);
        if (sendBufferSize > -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sendBufferSize > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                KBLOGGER.log(Level.WARNING, "Ignore invalid _value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStreamT.getSocket().getReceiveBufferSize());
            KBLOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStreamT.getSocket().getSendBufferSize());
        }
        newStreamT = this.enableSSL(newStreamT, sslMode, infoProps, connectTimeoutT, _version, cCMV2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<String[]> _paramList = this.getParametersForStartup(user, database, infoProps);
        String client_encoding = KBProperty.CLIENT_ENCODING.get(infoProps);
        newStreamT.setEncoding(Encoding.getJVMEncoding(client_encoding));
        this.sendStartupPacket(newStreamT, _paramList, client_encoding);
        int zipLevel = KBProperty.ZIP_LEVEL.getInt(infoProps);
        int compressLevel = KBProperty.COMPRESS_LEVEL.getInt(infoProps);
        if (compressLevel == 0 && zipLevel != 0) {
            compressLevel = zipLevel;
        }
        newStreamT.setZipLevel(compressLevel);
        newStreamT.setCompressLevel(compressLevel);
        if (compressLevel > 0) {
            newStreamT.setSocketBufferSize(KBProperty.COMPRESS_MAX.getInt(infoProps));
            newStreamT.setCompressMin(KBProperty.COMPRESS_MIN.getInt(infoProps));
            newStreamT.setOutPutCache(new KBByteBuffer(KBProperty.COMPRESS_MAX.getInt(infoProps)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.doAuthentication(newStreamT, _hostSpec.getHost(), user, infoProps);
        return newStreamT;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecsT, String user, String database, Properties infoProps, int _version, Object cCMV2) throws SQLException {
        HostRequirement targetServerTypeT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SslMode sslMode = SslMode.of(infoProps);
        String targetServerTypeStrT = KBProperty.TARGET_SERVER_TYPE.get(infoProps);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            targetServerTypeT = HostRequirement.getTargetServerType(targetServerTypeStrT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid targetServerType _value: {0}", targetServerTypeStrT), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SocketFactory socketFactoryT = SocketFactoryFactory.getSocketFactory(infoProps);
        HostChooser hostChooserT = HostChooserFactory.createHostChooser(hostSpecsT, targetServerTypeT, infoProps);
        Iterator<CandidateHost> hostIterT = hostChooserT.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (hostIterT.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            CandidateHost candidateHostT = hostIterT.next();
            HostSpec hostSpecT = candidateHostT._hostSpec;
            KBLOGGER.log(Level.FINE, "Trying to establish a protocol _version 3 _connection to {0}", hostSpecT);
            HostStatus knownStatusT = (HostStatus)((Object)knownStates.get(hostSpecT));
            if (knownStatusT != null && !candidateHostT.targetServerType.allowConnectingTo(knownStatusT)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!KBLOGGER.isLoggable(Level.FINER)) continue;
                KBLOGGER.log(Level.FINER, "Known status of _host {0} is {1}, and required status was {2}. Will try next _host", new Object[]{hostSpecT, knownStatusT, candidateHostT.targetServerType});
                continue;
            }
            KBStream newStreamT = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                try {
                    newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, sslMode, _version, cCMV2);
                }
                catch (SQLException sqlException1) {
                    Exception throwable;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (sslMode == SslMode.PREFER && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sqlException1.getSQLState())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throwable = null;
                        try {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, SslMode.DISABLE, _version, cCMV2);
                            KBLOGGER.log(Level.FINE, "Downgraded to non-encrypted _connection for _host {0}", hostSpecT);
                        }
                        catch (SQLException sqlException2) {
                            throwable = sqlException2;
                        }
                        catch (IOException ioException) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throwable = ioException;
                        }
                        if (throwable != null) {
                            KBLOGGER.log(Level.FINE, "sslMode==PREFER, however non-SSL _connection failed as well", throwable);
                            throw sqlException1;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sqlException1.getSQLState())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throwable = null;
                        try {
                            newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, SslMode.REQUIRE, _version, cCMV2);
                            KBLOGGER.log(Level.FINE, "Upgraded to encrypted _connection for _host {0}", hostSpecT);
                        }
                        catch (SQLException ee) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throwable = ee;
                        }
                        catch (IOException ee) {
                            throwable = ee;
                        }
                        if (throwable != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            KBLOGGER.log(Level.FINE, "sslMode==ALLOW, however SSL _connection failed as well", throwable);
                            throw sqlException1;
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw sqlException1;
                }
                int cancelSignalTimeoutT = KBProperty.CANCEL_SIGNAL_TIMEOUT.getInt(infoProps) * 1000;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                QueryExecutorImpl queryExecutorImpl = new QueryExecutorImpl(newStreamT, user, database, cancelSignalTimeoutT, infoProps);
                HostStatus _hostStatus = HostStatus.ConnectOK;
                if (candidateHostT.targetServerType != HostRequirement.any) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _hostStatus = this.isMaster(queryExecutorImpl) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, _hostStatus);
                knownStates.put(hostSpecT, _hostStatus);
                if (!candidateHostT.targetServerType.allowConnectingTo(_hostStatus)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    queryExecutorImpl.close();
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.First);
                knownStates.put(hostSpecT, HostStatus.First);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.runInitialQueries(queryExecutorImpl, infoProps);
                return queryExecutorImpl;
            }
            catch (ConnectException cex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINE, "ConnectException occurred while _connecting to {0}", hostSpecT);
                    KBLOGGER.log(Level.FINE, cex);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Connection to {0} refused. Check that the _hostname and port are correct and that the postmaster is accepting TCP/IP _connections.", hostSpecT), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.closeStream(newStreamT);
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINE, "IOException occurred while _connecting to {0}", hostSpecT);
                    KBLOGGER.log(Level.FINE, ioe);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("The _connection attempt failed.Reason:" + ioe.getMessage(), new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.closeStream(newStreamT);
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINE, "SQLException occurred while _connecting to {0}", hostSpecT);
                    KBLOGGER.log(Level.FINE, se);
                    continue;
                }
                throw se;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerTypeT}), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) throws KSQLException {
        int zipLevel;
        String options;
        String currentSchema;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String client_encoding = KBProperty.CLIENT_ENCODING.get(info);
        if (client_encoding == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            client_encoding = System.getProperty("file.encoding");
            KBProperty.CLIENT_ENCODING.set(info, client_encoding);
            KBLOGGER.log(Level.FINE, "Use current JVM default _encoding {0}", client_encoding);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<String[]> _paramList = new ArrayList<String[]>();
        _paramList.add(new String[]{"user", user});
        _paramList.add(new String[]{"database", database});
        _paramList.add(new String[]{"client_encoding", client_encoding});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _paramList.add(new String[]{"DateStyle", "ISO"});
        _paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createKingbase8TimeZone()});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Version assumeVersion = ServerVersion.from(KBProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            _paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = KBProperty.APPLICATION_NAME.get(info);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (appName != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _paramList.add(new String[]{"application_name", appName});
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = KBProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = KBProperty.CURRENT_SCHEMA.get(info)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = KBProperty.OPTIONS.get(info)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"options", options});
        }
        if ((zipLevel = KBProperty.ZIP_LEVEL.getInt(info)) < 0 || zipLevel >= 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("ZipLevel must be a integer _value greater to or equal to 0 and less to or equal to 9.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        int compressLevel = KBProperty.COMPRESS_LEVEL.getInt(info);
        if (compressLevel == 0 && zipLevel != 0) {
            compressLevel = zipLevel;
        }
        if (compressLevel < 0 || compressLevel >= 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("CompressLevel must be a integer _value greater to or equal to 0 and less to or equal to 9.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (compressLevel != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"compress_level", "" + compressLevel});
        }
        if (compressLevel != 0) {
            int compressMin = KBProperty.COMPRESS_MIN.getInt(info);
            if (compressMin < 128 || compressMin > 1024) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("compressMin must be a integer _value greater to or equal to 128 and less to or equal to 1024", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"compress_min", "" + compressMin});
            int compressMax = KBProperty.COMPRESS_MAX.getInt(info);
            if (compressMax < 8192 || compressMax > 0x2000000) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("compressMax must be a integer _value greater to or equal to 8192 and less to or equal to 33554432", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"compress_max", "" + compressMax});
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _paramList;
    }

    private static String createKingbase8TimeZone() {
        String startT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String timezoneStr = TimeZone.getDefault().getID();
        if (timezoneStr.length() <= 3 || !timezoneStr.startsWith("GMT")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timezoneStr;
        }
        char signT = timezoneStr.charAt(3);
        switch (signT) {
            case '-': {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = "GMT+";
                break;
            }
            case '+': {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = "GMT-";
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return timezoneStr;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return startT + timezoneStr.substring(4);
    }

    private KBStream enableSSL(KBStream kbStream, SslMode sslMode, Properties info, int connectTimeout, int _version, Object cCMV2) throws IOException, KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslMode == SslMode.DISABLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return kbStream;
        }
        if (sslMode == SslMode.ALLOW) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return kbStream;
        }
        KBLOGGER.log(Level.FINEST, " FE=> SSLRequest", new Object[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbStream.sendInteger4(8);
        kbStream.sendInteger2(1234);
        kbStream.sendInteger2(5679);
        kbStream.flush();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int beresp = kbStream.receiveChar();
        switch (beresp) {
            case 69: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINEST, " <=BE SSLError", new Object[0]);
                if (sslMode.requireEncryption()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                kbStream.close();
                return new KBStream(kbStream.getSocketFactory(), kbStream.getHostSpec(), connectTimeout, KBProperty.USEDISPATCH.getBoolean(info), _version, cCMV2);
            }
            case 78: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINEST, " <=BE SSLRefused", new Object[0]);
                if (sslMode.requireEncryption()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                return kbStream;
            }
            case 83: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINEST, " <=BE SSLOk", new Object[0]);
                MakeSSL.convert(kbStream, info);
                return kbStream;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("An _error occurred while setting up the SSL _connection.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(KBStream kbStream, List<String[]> _params, String _encoding) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < _params.size(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i != 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    details.append(", ");
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                details.append(_params.get(i)[0]);
                details.append("=");
                details.append(_params.get(i)[1]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] _encodedParams = new byte[_params.size() * 2][];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < _params.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _encodedParams[i * 2] = _params.get(i)[0].getBytes(_encoding);
            _encodedParams[i * 2 + 1] = _params.get(i)[1].getBytes(_encoding);
            length += _encodedParams[i * 2].length + 1 + _encodedParams[i * 2 + 1].length + 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbStream.sendInteger4(++length);
        kbStream.sendInteger2(3);
        kbStream.sendInteger2(0);
        for (byte[] _encodedParam : _encodedParams) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kbStream.send(_encodedParam);
            kbStream.sendChar(0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbStream.sendChar(0);
        kbStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAuthentication(KBStream kbStream, String _host, String user, Properties info) throws IOException, SQLException {
        ISSPIClient sspiClient;
        block42: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String password = KBProperty.PASSWORD.get(info);
            String client_encoding = KBProperty.CLIENT_ENCODING.get(info);
            sspiClient = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                block23: while (true) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int berespT = kbStream.receiveChar();
                    block3 : switch (berespT) {
                        case 69: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            int eleng = kbStream.receiveInteger4();
                            ServerErrorMessage _errorMsg = new ServerErrorMessage(kbStream.receiveErrorString(eleng - 4), null);
                            KBLOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", _errorMsg);
                            throw new KSQLException(_errorMsg, KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            int msgLen = kbStream.receiveInteger4();
                            int areq = kbStream.receiveInteger4();
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            switch (areq) {
                                case 5: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] md5Salt = kbStream.receive(4);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                    }
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] digest = MD5Digest.encode(user.getBytes(client_encoding), password.getBytes(client_encoding), md5Salt);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        KBLOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, "US-ASCII"));
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    kbStream.sendChar(112);
                                    kbStream.sendInteger4(4 + digest.length + 1);
                                    kbStream.send(digest);
                                    kbStream.sendChar(0);
                                    kbStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 3: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    KBLOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword", new Object[0]);
                                    KBLOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)", new Object[0]);
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] _encodedPassword = password.getBytes(client_encoding);
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    kbStream.sendChar(112);
                                    kbStream.sendInteger4(4 + _encodedPassword.length + 1);
                                    kbStream.send(_encodedPassword);
                                    kbStream.sendChar(0);
                                    kbStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    String gsslib = KBProperty.GSS_LIB.get(info);
                                    boolean usespnego = KBProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPIT = false;
                                    if (gsslib.equals("gssapi")) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        KBLOGGER.log(Level.FINE, "Using JSSE GSSAPI, _param gsslib=gssapi", new Object[0]);
                                    } else if (areq == 7 && !gsslib.equals("sspi")) {
                                        KBLOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced", new Object[0]);
                                    } else {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        sspiClient = this.createSSPI(kbStream, KBProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPIT = sspiClient.isSSPISupported();
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        KBLOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPIT);
                                        if (!useSSPIT) {
                                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                            sspiClient = null;
                                            if (gsslib.equals("sspi")) {
                                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                                throw new KSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (KBLOGGER.isLoggable(Level.FINE)) {
                                            KBLOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", useSSPIT, gsslib);
                                        }
                                    }
                                    if (useSSPIT) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        sspiClient.startSSPI();
                                        break block3;
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    MakeGSS.authenticate(kbStream, _host, user, password, KBProperty.JAAS_APPLICATION_NAME.get(info), KBProperty.KERBEROS_SERVER_NAME.get(info), usespnego, KBProperty.JAAS_LOGIN.getBoolean(info), KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                    break block3;
                                }
                                case 8: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    if (sspiClient == null) continue block23;
                                    sspiClient.continueSSPI(msgLen - 8);
                                    break block3;
                                }
                                case 10: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    KBLOGGER.log(Level.FINEST, " <=BE AuthenticationSASL", new Object[0]);
                                    throw new KSQLException(GT.tr("SCRAM authentication is not supported by this driver. You need JDK >= 8 and kbjdbc >= 42.2.0 (not \".jre\" _versions)", areq), KSQLState.CONNECTION_REJECTED);
                                }
                                case 13: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] sm3Salt = kbStream.receive(4);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationReqSM3(salt={0})", Utils.toHexString(sm3Salt));
                                    }
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    BouncyCastleUtils.initBouncyCastleProvider();
                                    byte[] digest = SM3Digest.encode(user.getBytes(client_encoding), password.getBytes(client_encoding), sm3Salt);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        KBLOGGER.log(Level.FINEST, " FE=> Password(sm3digest={0})", new String(digest, "US-ASCII"));
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    kbStream.sendChar(112);
                                    kbStream.sendInteger4(4 + digest.length + 1);
                                    kbStream.send(digest);
                                    kbStream.sendChar(0);
                                    kbStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 18: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] sm4Salt = kbStream.receive(16);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationReqSM4(salt={0})", Utils.toHexString(sm4Salt));
                                    }
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    BouncyCastleUtils.initBouncyCastleProvider();
                                    byte[] encode = SM4Utils.encodePBKDF2(user, password, sm4Salt, client_encoding);
                                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        KBLOGGER.log(Level.FINEST, " FE=> Password(sm4pbkdf2={0})", new String(encode, "US-ASCII"));
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    kbStream.sendChar(112);
                                    kbStream.sendInteger4(4 + encode.length + 1);
                                    kbStream.send(encode);
                                    kbStream.sendChar(0);
                                    kbStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 0: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    KBLOGGER.log(Level.FINEST, " <=BE AuthenticationOk", new Object[0]);
                                    break block42;
                                }
                                case 14: {
                                    CertAuthenticator certAuthenticator = new CertAuthenticator(kbStream, info);
                                    certAuthenticator.sendCertAndSign(msgLen - 4 - 4);
                                    break block3;
                                }
                                case 20: {
                                    FmKeyAuthenticator fmKeyAuthenticator = new FmKeyAuthenticator(kbStream);
                                    fmKeyAuthenticator.signAndSendCert(msgLen - 4 - 4, info.getProperty(KBProperty.USBKEY_PIN.getName()));
                                    break block3;
                                }
                                case 19: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    String macAddressString = ConnectionFactoryImpl.getMacAddressString();
                                    kbStream.sendChar(112);
                                    kbStream.sendInteger4(4 + macAddressString.getBytes(client_encoding).length + 1);
                                    kbStream.send(macAddressString.getBytes(client_encoding));
                                    kbStream.sendChar(0);
                                    kbStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                default: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    KBLOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    throw new KSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), KSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throw new KSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (sspiClient == null) throw throwable;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    sspiClient.dispose();
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINE, "Unexpected _error during SSPI context dispositional", ex);
                }
                throw throwable;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sspiClient == null) return;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            sspiClient.dispose();
            return;
        }
        catch (RuntimeException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Unexpected _error during SSPI context dispositional", ex);
            return;
        }
    }

    private static String getMacAddressString() throws SocketException {
        StringBuilder macSB = new StringBuilder();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            String name = networkInterface.getName();
            String displayName = networkInterface.getDisplayName();
            byte[] hardwareAddress = networkInterface.getHardwareAddress();
            if (hardwareAddress == null) continue;
            KBLOGGER.log(Level.FINE, "displayName:{0};name:{1}", displayName, name);
            for (int i = 0; i < hardwareAddress.length; ++i) {
                macSB.append(String.format("%02X%s", hardwareAddress[i], i < hardwareAddress.length - 1 ? ":" : ""));
            }
            macSB.append("/");
        }
        return macSB.length() > 0 ? macSB.substring(0, macSB.length() - 1) : macSB.toString();
    }

    private void runInitialQueries(QueryExecutor queryExecutorImpl, Properties info) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String initParams = KBProperty.INIT_PARAMS.get(info);
        if (initParams != null) {
            String[] _params;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (String _param : _params = initParams.split(";")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    SetupQueryRunner.run(queryExecutorImpl, "SET " + _param, false);
                }
                catch (SQLException sqlException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw sqlException;
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String assumeMinServerVersion = KBProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        int dbVersion = queryExecutorImpl.getServerVersionNum();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SetupQueryRunner.run(queryExecutorImpl, "SET extra_float_digits = 3", false);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String appName = KBProperty.APPLICATION_NAME.get(info);
        if (appName != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder _sql = new StringBuilder();
            _sql.append("SET application_name = '");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Utils.escapeLiteral(_sql, appName, queryExecutorImpl.getStandardConformingStrings());
            _sql.append("'");
            SetupQueryRunner.run(queryExecutorImpl, _sql.toString(), false);
        }
    }

    private boolean isMaster(QueryExecutor queryExecutorImpl) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[][] _results = SetupQueryRunner.run(queryExecutorImpl, "show transaction_read_only", true);
        String _value = queryExecutorImpl.getEncoding().decode(_results[0]);
        return _value.equalsIgnoreCase("off");
    }
}

