/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.tts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.kit.PathKit;
import itez.kit.EByte;
import itez.kit.ECode;
import itez.kit.EDate;
import itez.kit.EFile;
import itez.kit.EHttp;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.EUid;
import itez.kit.fileup.EFileKit;
import itez.kit.tts.ITTS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public class TtsXunFei
implements ITTS {
    public Map<String, String> genHeaders() {
        HashMap params = Maps.newHashMap();
        params.put("auf", "audio/L16;rate=16000");
        params.put("aue", "lame");
        params.put("voice_name", "xiaoyan");
        String paramsJson = EJson.toJson(params);
        String paramsBase = ECode.base64Encode(paramsJson);
        String appId = EProp.TtsXunFeiAppId;
        String apiKey = EProp.TtsXunFeiApiKey;
        String curTime = EDate.getUTCTime() + "";
        String checkSum = ECode.md5(apiKey + curTime + paramsBase);
        HashMap headers = Maps.newHashMap();
        headers.put("X-Appid", appId);
        headers.put("X-CurTime", curTime);
        headers.put("X-Param", paramsBase);
        headers.put("X-CheckSum", checkSum);
        return headers;
    }

    public File restful(String text) {
        HashMap forms = Maps.newHashMap();
        forms.put("text", text);
        File file = null;
        Response response = EHttp.me.postFormResponse(EProp.TtsXunFeiUrl, forms, this.genHeaders());
        if (response == null) {
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef\uff01");
        }
        String contentType = response.header("Content-Type");
        if (contentType.equals("audio/mpeg")) {
            String path = EProp.FileUploadTemp;
            if (!path.startsWith("/")) {
                path = PathKit.getWebRootPath() + File.separator + path;
            }
            if ((file = new File(path + File.separator + EUid.generator() + ".mp3")).exists()) {
                throw new RuntimeException("\u5408\u6210\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            try {
                byte[] bytes = response.body().bytes();
                EFile.write(file, bytes);
            }
            catch (Exception e) {
                throw new RuntimeException("\u4fdd\u5b58\u8bed\u97f3\u5408\u6210\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff01");
            }
        }
        String body = null;
        try {
            body = response.body().string();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8c03\u7528\u8bed\u97f3\u5408\u6210\u63a5\u53e3\u65f6\u53d1\u751f\u9519\u8bef\uff08" + e.getMessage() + "\uff09");
        }
        Map err = EJson.parse(body, Map.class);
        String errCode = (String)err.get("code");
        throw new RuntimeException("\u8c03\u7528\u8bed\u97f3\u5408\u6210\u63a5\u53e3\u65f6\u53d1\u751f\u9519\u8bef\uff08" + errCode + "\uff09");
        return file;
    }

    @Override
    public String[] execute(String domain, String text) {
        List<String> strs = EByte.splitByte(text, EProp.TtsXunFeiByteLimit);
        ArrayList urls = Lists.newArrayList();
        for (String strSub : strs) {
            File ttsFile = this.restful(strSub);
            if (ttsFile == null) continue;
            String ttsFileUrl = EFileKit.upload(ttsFile, domain + "/tts");
            urls.add(ttsFileUrl);
        }
        return urls.toArray(new String[strs.size()]);
    }
}

