/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.mall;

import itez.kit.mall.MailIden;
import itez.kit.mall.MailInfo;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSender {
    public static boolean sendTextMail(MailInfo mailInfo) {
        MailIden authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MailIden(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            String nickName = mailInfo.getNickName();
            String emailFrom = mailInfo.getFromAddress();
            if (nickName != null) {
                nickName = MimeUtility.encodeText((String)nickName);
                emailFrom = nickName + " <" + emailFrom + ">";
            }
            InternetAddress from = new InternetAddress(emailFrom);
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean sendHtmlMail(MailInfo mailInfo) {
        MailIden authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MailIden(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            String nick = mailInfo.getNickName();
            String emailFrom = mailInfo.getFromAddress();
            if (nick != null) {
                nick = MimeUtility.encodeText((String)nick);
                emailFrom = nick + " <" + emailFrom + ">";
            }
            InternetAddress from = new InternetAddress(emailFrom);
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

