/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import itez.kit.guice.MyMethodInterceptor;
import itez.kit.guice.service.Person;
import itez.kit.guice.service.impl.Men;
import itez.kit.guice.service.impl.Student;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

public class ModuleBinding
implements Module {
    private Injector injector = Guice.createInjector((Module[])new Module[]{this});
    public static final ModuleBinding me = new ModuleBinding();

    private ModuleBinding() {
    }

    public <T> T getInstance(Class<?> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    public void configure(Binder binder) {
        binder.bind(Person.class).to(Student.class);
        AbstractMatcher<Method> notSynthetic = new AbstractMatcher<Method>(){

            public boolean matches(Method method) {
                return !method.isSynthetic();
            }
        };
        binder.bindInterceptor(Matchers.any(), (Matcher)notSynthetic, new MethodInterceptor[]{new MyMethodInterceptor()});
    }

    public static void main(String[] args) {
        ModuleBinding binder = me;
        Person per1 = (Person)binder.getInstance(Person.class);
        per1.say("netwild");
        Person per2 = (Person)binder.getInstance(Person.class);
        per2.say("zmy");
        System.out.println("per1\u7684name\uff1a" + per1.getName());
        Men men = (Men)binder.getInstance(Men.class);
        men.howOld(32);
    }
}

