/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.cache;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.cache.EhcacheImpl;
import itez.kit.cache.ICache;
import itez.kit.cache.NoCache;
import itez.kit.cache.RedisImpl;
import itez.kit.cache.ehredis.EhredisImpl;
import itez.kit.log.ELogBase;

public class ECacheFactory {
    private static final ELogBase log = ELog.log(ECacheFactory.class);
    public static final ECacheFactory me = new ECacheFactory();
    private ICache cacheImpl = null;

    private ECacheFactory() {
    }

    public ICache getCache() {
        if (this.cacheImpl == null) {
            if (EProp.DevMode.booleanValue()) {
                this.cacheImpl = new NoCache();
                log.info("\u5f53\u524d\u5904\u4e8e\u8c03\u8bd5\u73af\u5883\uff0c\u81ea\u52a8\u5173\u95ed\u7f13\u5b58\uff01");
            } else {
                String cachePlan = EProp.CachePlan.toLowerCase();
                log.info("\u6570\u636e\u7f13\u5b58\u65b9\u6848\uff1a{}", cachePlan);
                if (cachePlan.equals("ehcache")) {
                    this.cacheImpl = new EhcacheImpl();
                } else if (cachePlan.equals("redis")) {
                    this.cacheImpl = new RedisImpl();
                } else if (cachePlan.equals("ehredis")) {
                    this.cacheImpl = new EhredisImpl();
                }
            }
        }
        return this.cacheImpl;
    }
}

