/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import itez.kit.ERegex;
import itez.kit.EStr;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class EDate {
    public static final String PATTERN_Y = "yyyy";
    public static final String PATTERN_YM = "yyyy-MM";
    public static final String PATTERN_MD = "MM-dd";
    public static final String PATTERN_YMD = "yyyy-MM-dd";
    public static final String PATTERN_YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_HM = "HH:mm";
    public static final String PATTERN_YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YMD_HMS_S = "yyyy-MM-dd HH:mm:ss:SSS";

    public static Date getDate() {
        return new Date();
    }

    public static long getTime() {
        return new Date().getTime();
    }

    public static long getUTCTime() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis() / 1000L;
    }

    public static String format(Date date) {
        return EDate.format(date, PATTERN_YMD);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date parse(String date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(date);
        }
        catch (Exception e) {
            return EDate.getDate();
        }
    }

    public static Date parse(String date) {
        String pattern = EDate.parsePattern(date);
        return EStr.isNull(pattern) ? EDate.getDate() : EDate.parse(date, pattern);
    }

    private static String parsePattern(String date) {
        String pattern = null;
        if (ERegex.has(date, "^\\d{4}$")) {
            pattern = PATTERN_Y;
        } else if (ERegex.has(date, "^\\d{4}\\-\\d{1,2}$")) {
            pattern = PATTERN_YM;
        } else if (ERegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}$")) {
            pattern = PATTERN_YMD;
        } else if (ERegex.has(date, "^\\d{1,2}\\-\\d{1,2}$")) {
            pattern = PATTERN_MD;
        } else if (ERegex.has(date, "^\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_HM;
        } else if (ERegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_YMD_HM;
        } else if (ERegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_YMD_HMS;
        } else if (ERegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}\\:\\d{1,2}\\:\\d{1,3}$")) {
            pattern = PATTERN_YMD_HMS_S;
        }
        return pattern;
    }

    public static String part(DatePart dp, Date dt) {
        if (dp == DatePart.YEAR) {
            return EDate.format(dt, PATTERN_Y);
        }
        if (dp == DatePart.MONTH) {
            return EDate.format(dt, "MM");
        }
        if (dp == DatePart.DAY) {
            return EDate.format(dt, "dd");
        }
        if (dp == DatePart.HOUR) {
            return EDate.format(dt, "HH");
        }
        if (dp == DatePart.MINUTE) {
            return EDate.format(dt, "mm");
        }
        return EDate.format(dt, "ss");
    }

    public static String diffMsg(Date start, Date end) {
        long diff = (end.getTime() - start.getTime()) / 1000L;
        long day = diff / 86400L;
        long hour = diff % 86400L / 3600L;
        long minute = diff % 3600L / 60L;
        long second = diff % 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(day);
        sb.append("\u5929");
        sb.append(hour);
        sb.append("\u5c0f\u65f6");
        sb.append(minute);
        sb.append("\u5206");
        sb.append(second);
        sb.append("\u79d2");
        return sb.toString();
    }

    public static int diff(DateUtil dateUtil, Date start, Date end) {
        int diffLen = 0;
        if (dateUtil == DateUtil.DAY) {
            diffLen = 86400000;
        } else if (dateUtil == DateUtil.HOUR) {
            diffLen = 3600000;
        } else if (dateUtil == DateUtil.MINUTE) {
            diffLen = 60000;
        } else if (dateUtil == DateUtil.SECOND) {
            diffLen = 1000;
        }
        return (int)((end.getTime() - start.getTime()) / (long)diffLen);
    }

    public static Duration diff(Date start, Date end) {
        LocalDateTime ld1 = EDate.toLocalDateTime(start);
        LocalDateTime ld2 = EDate.toLocalDateTime(end);
        Duration duration = Duration.between(ld1, ld2);
        return duration;
    }

    public static Date add(DateUtil dateUtil, Date start, int diff) {
        int diffLen = 0;
        if (dateUtil == DateUtil.DAY) {
            diffLen = 86400000;
        } else if (dateUtil == DateUtil.HOUR) {
            diffLen = 3600000;
        } else if (dateUtil == DateUtil.MINUTE) {
            diffLen = 60000;
        } else if (dateUtil == DateUtil.SECOND) {
            diffLen = 1000;
        }
        return new Date(start.getTime() + (long)(diff * diffLen));
    }

    private static Date addUtil(Date start, int diff, int calendarType) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(start);
        ((Calendar)calendar).add(calendarType, diff);
        return calendar.getTime();
    }

    public static Date addYear(Date start, int diff) {
        return EDate.addUtil(start, diff, 1);
    }

    public static Date addMonth(Date start, int diff) {
        return EDate.addUtil(start, diff, 2);
    }

    public static Date addDay(Date start, int diff) {
        return EDate.addUtil(start, diff, 5);
    }

    public static Date addHour(Date start, int diff) {
        return EDate.addUtil(start, diff, 10);
    }

    public static Date addMinute(Date start, int diff) {
        return EDate.addUtil(start, diff, 12);
    }

    public static Date addSecond(Date start, int diff) {
        return EDate.addUtil(start, diff, 13);
    }

    public static String getDateInWeek(Date date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7) - 1;
        if (dayIndex < 0) {
            dayIndex = 0;
        }
        return weekDays[dayIndex];
    }

    public static Date[] getMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        Date start = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date end = calendar.getTime();
        return new Date[]{start, end};
    }

    public static boolean isExpire(Date date) {
        return date.before(EDate.getDate());
    }

    public static LocalDate toLocalDate(Date date) {
        int year = Integer.parseInt(EDate.part(DatePart.YEAR, date));
        int month = Integer.parseInt(EDate.part(DatePart.MONTH, date));
        int day = Integer.parseInt(EDate.part(DatePart.DAY, date));
        LocalDate ldate = LocalDate.of(year, month, day);
        return ldate;
    }

    public static LocalTime toLocalTime(Date date) {
        int hour = Integer.parseInt(EDate.part(DatePart.HOUR, date));
        int minute = Integer.parseInt(EDate.part(DatePart.MINUTE, date));
        int second = Integer.parseInt(EDate.part(DatePart.SECOND, date));
        LocalTime ldate = LocalTime.of(hour, minute, second);
        return ldate;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        LocalDate ldate = EDate.toLocalDate(date);
        LocalTime ltime = EDate.toLocalTime(date);
        LocalDateTime ldatetime = LocalDateTime.of(ldate, ltime);
        return ldatetime;
    }

    public static void main(String[] args) {
        Date dd = EDate.getDate();
        Date dd1 = EDate.addYear(dd, 1);
        Date[] dds = EDate.getMonthDate(dd);
        System.out.println(EDate.format(dds[0]));
        System.out.println(EDate.format(dds[1]));
        System.out.println(EDate.format(dd));
        System.out.println(EDate.format(dd1));
        String d1 = "2018-01-26 23:25:00";
        String d2 = "2018-01-27 00:25:00";
        LocalDateTime ld1 = EDate.toLocalDateTime(EDate.parse(d1));
        LocalDateTime ld2 = EDate.toLocalDateTime(EDate.parse(d2));
        Duration duration = Duration.between(ld1, ld2);
        System.out.println(d1);
        System.out.println(d2);
        System.out.println(duration.toMinutes());
    }

    public static enum DatePart {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }

    public static enum DateUtil {
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

