package itez.kit.tts;

import java.io.File;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.kit.PathKit;

import itez.kit.EByte;
import itez.kit.ECode;
import itez.kit.EDate;
import itez.kit.EFile;
import itez.kit.EHttp;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.EUid;
import itez.kit.fileup.EFileKit;
import okhttp3.Response;

public class TtsXunFei implements ITTS {
	
	public Map<String, String> genHeaders(){
		Map<String, String> params = Maps.newHashMap();
		params.put("auf", "audio/L16;rate=16000");
		params.put("aue", "lame");
		params.put("voice_name", "xiaoyan");

		String paramsJson = EJson.toJson(params);
		String paramsBase = ECode.base64Encode(paramsJson);
		
		String appId = EProp.TtsXunFeiAppId;
		String apiKey = EProp.TtsXunFeiApiKey;
		String curTime = EDate.getUTCTime() + "";
		String checkSum = ECode.md5(apiKey + curTime + paramsBase);
		
		Map<String, String> headers = Maps.newHashMap();
		headers.put("X-Appid", appId);
		headers.put("X-CurTime", curTime);
		headers.put("X-Param", paramsBase);
		headers.put("X-CheckSum", checkSum);
		return headers;
	}
	
	@SuppressWarnings("unchecked")
	public File restful(String text){
		Map<String, String> forms = Maps.newHashMap();
		forms.put("text", text);
		
		File file = null;
		Response response = EHttp.me.postFormResponse(EProp.TtsXunFeiUrl, forms, genHeaders());
		if(response == null){
			throw new RuntimeException("网络请求时发生错误！");
		}else{
			String contentType = response.header("Content-Type");
			if(contentType.equals("audio/mpeg")){
				String path = EProp.FileUploadTemp;
				if(!path.startsWith("/")) path = PathKit.getWebRootPath() + File.separator + path;
				file = new File(path + File.separator + EUid.generator() + ".mp3");
				if(file.exists()) throw new RuntimeException("合成文件已经存在！");
				try {
					byte[] bytes = response.body().bytes();
					EFile.write(file, bytes);
				} catch (Exception e) {
					throw new RuntimeException("保存语音合成文件时发生错误！");
				}
			}else{
				String body = null;
				try {
					body = response.body().string();
				} catch (Exception e) {
					throw new RuntimeException("调用语音合成接口时发生错误（" + e.getMessage() + "）");
				}
				Map<String, String> err = EJson.parse(body, Map.class);
				String errCode = err.get("code");
				throw new RuntimeException("调用语音合成接口时发生错误（" + errCode + "）");
			}
		}
		return file;
	}

	@Override
	public String[] execute(String domain, String text) {
		List<String> strs = EByte.splitByte(text, EProp.TtsXunFeiByteLimit);
		List<String> urls = Lists.newArrayList();
		for(String strSub : strs){
			File ttsFile = restful(strSub);
			if(ttsFile != null){
				String ttsFileUrl = EFileKit.upload(ttsFile, domain + "/tts");
				urls.add(ttsFileUrl);
			}
		}
		return urls.toArray(new String[strs.size()]);
	}

}
