package itez.kit.tts;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;

public class TtsFactory {

	private static final ELogBase log = ELog.log(TtsFactory.class);
	public final static TtsFactory me = new TtsFactory();
	private ITTS tts = null;
	private TtsFactory(){}
	
	public ITTS getTts() {
		if(null == tts){
			String ttsPlan = EProp.TtsPlan.toLowerCase();
			log.info("语音合成方案：{}", ttsPlan);
			if(ttsPlan.equals("xunfei")){
				tts = new TtsXunFei();
			}
		}
		return tts;
	}
	
	public void setTts(ITTS tts) {
		this.tts = tts;
	}

}
