package itez.kit.serializer;

import itez.kit.EProp;

public class ESerializerFactory {

    public final static ESerializerFactory me = new ESerializerFactory();
    private ISerializer serizlizer = null;
    private ESerializerFactory(){}

    public void setSerializer(ISerializer serizlizer){
    	this.serizlizer = serizlizer;
    }

    public ISerializer getSerializer() {
		if(null == this.serizlizer){
			String SerializerPlan = EProp.SerializerPlan.toLowerCase();
			if(SerializerPlan.equals("fastjson")){
				this.serizlizer = new FastjsonImpl();
			}else if(SerializerPlan.equals("kryo")){
				this.serizlizer = new KryoImpl();
			}else{
				this.serizlizer = new FstImpl();
			}
		}
		return this.serizlizer;
    }

}

