package itez.kit.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.jfinal.json.MixedJsonFactory;

@SuppressWarnings("unused")
public class EJsonImpl extends EJsonBase {

	@Override
	public String toJson(Object object) {
		// 使用JFinal的toJson：
		return MixedJsonFactory.me().getJson().toJson(object);
		
		//使用fastjson的toJson：
		//String dp = datePattern != null ? datePattern : getDefaultDatePattern();
		//if (dp == null) {
		//	return JSON.toJSONString(object);
		//} else {
		//	return JSON.toJSONStringWithDateFormat(object, dp, SerializerFeature.WriteDateUseDateFormat);	// return JSON.toJSONString(object, SerializerFeature.WriteDateUseDateFormat);
		//}
	}

	@Override
	public String toJsonFilter(Object object, String... properties) {
		//使用fastjson的带筛选toJson：
		SimplePropertyPreFilter filter = new SimplePropertyPreFilter(properties);
		return JSON.toJSONString(object, filter);
	}

	@Override
	public <T> T parse(String jsonString, Class<T> type) {
		//使用fastjson的parse
		return JSON.parseObject(jsonString, type);
	}

}
