package itez.kit.guice;

import java.lang.reflect.Method;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matchers;

import itez.kit.guice.service.Person;
import itez.kit.guice.service.impl.Men;
import itez.kit.guice.service.impl.Student;

public class ModuleBinding implements Module {
	
	private Injector injector;
	
	public static final ModuleBinding me = new ModuleBinding();
	
	private ModuleBinding(){
		injector = Guice.createInjector(this);
	}
	
	@SuppressWarnings("unchecked")
	public <T> T getInstance(Class<?> clazz){
		return (T) injector.getInstance(clazz);
	}
	
	@Override
	public void configure(Binder binder) {
		binder.bind(Person.class).to(Student.class);
		
        AbstractMatcher<Method> notSynthetic = new AbstractMatcher<Method>() {
            @Override
            public boolean matches(Method method) {
                return !method.isSynthetic();
            }
        };
        binder.bindInterceptor(Matchers.any(), notSynthetic, new MyMethodInterceptor()) ;
	}
	
	public static void main(String[] args) {
		
		ModuleBinding binder = ModuleBinding.me;
		Person per1 = binder.getInstance(Person.class);
		per1.say("netwild");
		Person per2 = binder.getInstance(Person.class);
		per2.say("zmy");
		System.out.println("per1的name：" + per1.getName());
		Men men = binder.getInstance(Men.class);
		men.howOld(32);
	}
	
}
