package itez.kit.fileup;

import java.io.File;
import java.nio.file.Files;
import java.util.List;

import com.google.common.collect.Lists;
import com.jfinal.kit.PathKit;

import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.EUid;

public class LocalImpl implements IFileUp {
	
	private String Url; //虚拟目录域名
	private String DiskPath; //虚拟目录所在硬盘位置
	
	private static final String FileSep = File.separator;
	
	public LocalImpl(){
		DiskPath = EProp.LocalFilePath;
		Url = EProp.LocalFileUrl;
		
		if(!Url.endsWith("/")){
			Url += "/";
		}
		DiskPath = formatPath(DiskPath);
    	if(!DiskPath.startsWith("/") && !DiskPath.startsWith("\\") && !ERegex.has(DiskPath, "^[A-Za-z]\\:")){
    		DiskPath = PathKit.getWebRootPath() + FileSep + DiskPath;
    	}
		if(!DiskPath.endsWith(FileSep)){
			DiskPath += FileSep;
		}
	}
	
	@Override
	public String upload(File file, String subPath) {
		return upload(file, subPath, true);
	}
	
	@Override
	public String upload(File file, String subPath, boolean uuidName) {
		String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
		String fileName = file.getName();
		String extName = fileName.substring(fileName.lastIndexOf("."));
		if(EStr.notEmpty(subPath)){
			if(subPath.startsWith(FileSep)) subPath = subPath.substring(1);
			if(!subPath.endsWith(FileSep)) subPath += FileSep;
		}
		String key;
		if(uuidName){
			key = String.format("%s%s%s%s", subPath, fileIndex, EUid.generator(), extName);
		}else{
			key = String.format("%s%s", subPath, fileName);
		}
	    try {
	    	String dest = formatPath(DiskPath + key);
	    	String toPathStr = dest.substring(0, dest.lastIndexOf(FileSep));
	    	File toPath = new File(toPathStr);
	    	if(!toPath.exists()) toPath.mkdirs();
	    	Files.move(file.toPath(), new File(dest).toPath());
	        return formatUrl(Url + key);
	    }catch (Exception e) {
	    	System.err.println(e.toString());
	    }
	    return null;
	}
	
	private String formatPath(String path){
		return path.replace("/", FileSep).replace("\\", FileSep);
	}
	
	private String formatUrl(String url){
		return url.replace(FileSep, "/").replace("\\", "/");
	}

	@Override
	public List<FileItem> list(String subPath) {
		List<FileItem> temps = Lists.newArrayList();
    	String root = formatPath(DiskPath + subPath);
		File dir = new File(root);
		if(!dir.exists()) return temps;
		if(dir.isFile()) return temps;
		File[] list = dir.listFiles();
		if(list == null || list.length == 0) return temps;
		for(File file : list){
			if(file.isDirectory()) continue;
			FileItem temp = new FileItem();
			temp.setFileName(file.getName());
			temp.setFilePath(file.getAbsolutePath());
			temp.setFileSize(file.length());
			temp.setMimeType(temp.getExtName());
			String url = file.getAbsolutePath().substring(DiskPath.length()).replace(File.separator, "/");
			temp.setUrl(Url + url);
			temps.add(temp);
		}
		return temps;
	}

	@Override
	public boolean remove(String fileName) {
		File file = new File(fileName);
		if(!file.exists()) return false;
		if(file.isDirectory()) return false;
		return file.delete();
	}
	
	public static void main(String[] args) {
		LocalImpl fileio = new LocalImpl();
		File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
		String path = fileio.upload(file, "");
		System.out.println(path);
	}

}