package itez.kit.fileup;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;

public final class EFileFactory {

	private static final ELogBase log = ELog.log(EFileFactory.class);
	public final static EFileFactory me = new EFileFactory();
	private IFileUp io = null;
	private EFileFactory(){}
	
	public void setFileIO(IFileUp io){
		this.io = io;
	}
	
	public IFileUp getFileIO(){
		if(null == this.io){
			String fileStorePlan = EProp.FileStorePlan.toLowerCase();
			log.info("文件上传方案：{}", fileStorePlan);
			if(fileStorePlan.equals("qiniu")){
				this.io = new QiNiuImpl();
			}else if(fileStorePlan.equals("tencent")){
				this.io = new TencentImpl();
			}else{
				this.io = new LocalImpl();
			}
		}
		return this.io;
	}
	
}
