package itez.kit;

import com.jfinal.template.Engine;
import com.jfinal.template.Template;

/**
 * 表达式解析
 * @author netwild
 *
 */
public class El {

	public final static El me = new El();
	
	private Engine engine;
	
	private ERet objs;
	
	@SuppressWarnings("unchecked")
	private El(){
		engine = new Engine();
		objs = ERet.create();
		objs.put("EStr", new EStr());
		objs.put("EDate", new itez.kit.EDate());
		objs.put("ERegex", new itez.kit.ERegex());
		objs.put("EJson", new itez.kit.EJson());
	}
	
	/**
	 * 执行表达式
	 * @param expression 表达式
	 * @return
	 */
	public String exec(String expression){
		return exec(expression, null);
	}
	
	/**
	 * 执行表达式
	 * @param expression 表达式
	 * @param context 上下文参数表
	 * @return
	 */
	public String exec(String expression, ERet context){
		Template template = engine.getTemplateByString(expression);
		String ret = template.renderToString(context.set(objs));
		return ret;
	}
	
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		int a = 11;
		String expression = "#(EStr.addPrefix(1+2+a, 5))";
		
		ERet map = ERet.create();
		map.put("a", a);
		map.put("EStr", new EStr());
		String ret = El.me.exec(expression, map);
		System.out.println(ret);
	}
	
}
