package itez.kit;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections4.MapUtils;

import com.jfinal.json.Json;

@SuppressWarnings("unchecked")
public class EMap<K, V> extends HashMap<K, V> {

	private static final long serialVersionUID = 4958504094628259069L;

	public static<K, V> EMap<K, V> create() {
		return new EMap<K, V>();
	}

	public static<K, V> EMap<K, V> create(K k, V v) {
		return new EMap<K, V>().set(k, v);
	}
	
	public EMap<K, V> set(K k, V v){
		super.put((K)k, (V)v);
		return this;
	}

	public EMap<K, V> set(Map<K, V> map){
		super.putAll(map);
		return this;
	}

	public EMap<K, V> set(EMap<K, V> map){
		super.putAll(map);
		return this;
	}
	
	public EMap<K, V> delete(K key) {
		super.remove(key);
		return this;
	}
	
	public <T> T getAs(K key) {
		return (T)get(key);
	}
	
	public String getStr(K key) {
		Object s = get(key);
		return s != null ? s.toString() : null;
	}
	
	public Integer getInt(K key) {
		Number n = (Number)get(key);
		return n != null ? n.intValue() : null;
	}
	
	public Long getLong(K key) {
		Number n = (Number)get(key);
		return n != null ? n.longValue() : null;
	}
	
	public Number getNumber(K key) {
		return (Number)get(key);
	}
	
	public Boolean getBoolean(K key) {
		return (Boolean)get(key);
	}
	
	public Boolean isExist(K key){
		return super.containsKey(key);
	}
	
	public Boolean isNull(K key){
		return get(key) == null;
	}
	
	public Boolean notNull(K key){
		return get(key) != null;
	}
	
	public boolean isTrue(K key) {
		Object value = get(key);
		return (value instanceof Boolean && ((Boolean)value == true));
	}
	
	public boolean isFalse(K key) {
		Object value = get(key);
		return (value instanceof Boolean && ((Boolean)value == false));
	}
	
	public String toJson() {
		return Json.getJson().toJson(this);
	}
	
	public boolean equals(Object map) {
		return map instanceof EMap && super.equals(map);
	}
	
	@SuppressWarnings("rawtypes")
	public static boolean notEmpty(EMap map){
		return MapUtils.isNotEmpty(map) && map.size() > 0;
	}
	
}
