package itez.kit;

import itez.kit.mall.MailInfo;
import itez.kit.mall.MailSender;

public class EMail {
	
	public final static EMail me = new EMail();
	private MailInfo mailInfo = null;
	private EMail(){}
	
	/**
	 * @category 初始化Email服务环境参数
	 * @param host SMTP服务器名称
	 * @param validate 是否需要身份验证
	 * @param ssl 是否需要SSL加密
	 * @param userName SMTP服务器用户名
	 * @param pwd SMTP服务器登录口令
	 * @param nick 发送者昵称
	 */
	public void init(String host, boolean validate, boolean ssl, String userName, String pwd, String nickName){
		MailInfo mailInfo = new MailInfo();
		mailInfo.setMailServerHost(host);
		mailInfo.setMailServerPort(ssl ? "465" : "25");
		mailInfo.setValidate(validate);
		mailInfo.setSsl(ssl);
		mailInfo.setUserName(userName);
		mailInfo.setPassword(pwd);
		mailInfo.setFromAddress(userName);
		mailInfo.setNickName(nickName);
		this.mailInfo = mailInfo;
	}

	/**
	 * @category 发送文本邮件
	 * @param toEmail 收件者地址
	 * @param subject 标题
	 * @param content 内容
	 * @return
	 */
	public boolean sendTextMail(String toEmail, String subject, String content){
		if(null == this.mailInfo){
			System.out.println("错误：EMail服务还未初始化！");
			return false;
		}
		MailInfo mailInfo = this.mailInfo;
		mailInfo.setToAddress(toEmail);
		mailInfo.setSubject(subject);
		mailInfo.setContent(content);
		return MailSender.sendTextMail(mailInfo);
	}
	
	/**
	 * @category 发送HTML邮件
	 * @param toEmail 收件者地址
	 * @param subject 标题
	 * @param content 内容
	 * @return
	 */
	public boolean sendHtmlMail(String toEmail, String subject, String content){
		if(null == this.mailInfo){
			System.out.println("错误：EMail服务还未初始化！");
			return false;
		}
		MailInfo mailInfo = this.mailInfo;
		mailInfo.setToAddress(toEmail);
		mailInfo.setSubject(subject);
		mailInfo.setContent(content);
		return MailSender.sendHtmlMail(mailInfo);
	}
	
}
