package itez.kit;

import itez.kit.json.EJsonFactory;
import itez.kit.json.EJsonFomat;

public class EJson {

	public static String toJson(Object object) {
		return EJsonFactory.me.getJson().toJson(object);
	}
	
	public static String toJsonFilter(Object object, String... properties){
		return EJsonFactory.me.getJson().toJsonFilter(object, properties);
	}
	
	public static <T> T parse(String jsonString, Class<T> type) {
		return EJsonFactory.me.getJson().parse(jsonString, type);
	}
	
	public static String format(String jsonString){
		return EJsonFomat.format(jsonString);
	}
	
	public static String compress(String jsonString){
		return EJsonFomat.compress(jsonString);
	}

}
