package itez.kit;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;

import javax.imageio.ImageIO;

//import com.sun.image.codec.jpeg.JPEGCodec;
//import com.sun.image.codec.jpeg.JPEGImageEncoder;

/**
 * 图像压缩工具
 * 
 * @author 张明玉
 */
public class EImageResize {

	/**
	 * 等比例压缩图像
	 * 压缩后的宽度和高度只需传入一项即可；如果两者都传入，将按传入的尺寸进行压缩，不保证比例。
	 * @param imgSrc 待压缩图像路径
	 * @param distSrc 压缩后的图像保存路径
	 * @param distWidth 压缩后的宽度
	 * @param distHeight 压缩后的高度
	 * @param skipToBig 如果压缩后的尺寸大于原始尺寸，是否取消压缩
	 * @throws Exception
	 */
	public static void resize(String imgSrc, String distSrc, Integer distWidth, Integer distHeight, boolean skipToBig) throws Exception{
		File file = new File(imgSrc);
		if(!file.exists()) throw new Exception("原图不存在！"); //原图不存在
		Image src = ImageIO.read(file);
		int width = 100, height = 100; //压缩后的宽度及高度
		if(null == distWidth && null == distHeight){ //宽度及高度至少明确一项
			throw new Exception("至少传入宽度和高度中的一项");
		}else if(null != distWidth && null != distHeight){ //按传入的宽度及高度压缩，不保证比例
			width = distWidth;
			height = distHeight;
		}else{
			int oldWidth = src.getWidth(null); //原图像宽度
			int oldHeight = src.getHeight(null); //原图像高度
			if(null != distWidth){ //按宽度压缩，保证比例
				if(distWidth >= oldWidth && skipToBig){ //压缩后的尺寸更大，跳出操作
					return;
				}else{
					width = distWidth;
					height = (int) oldHeight * width / oldWidth;
				}
			}else{ //按高度压缩，保证比例
				if(distHeight >= oldHeight && skipToBig){ //压缩后的尺寸更大，跳出操作
					return;
				}else{
					height = distHeight;
					width = (int) oldWidth * height / oldHeight;
				}
			}
		}
		BufferedImage dist = new BufferedImage(width, height, BufferedImage.TYPE_3BYTE_BGR);
		dist.getGraphics().drawImage(src, 0, 0, width, height, null);
		FileOutputStream out = new FileOutputStream(distSrc);
		//JPEGImageEncoder在JDK1.7以后不再支持
		//JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		//encoder.encode(dist);
		ImageIO.write(dist, "jpg", out);
		out.close();
	}
	
	/**
	 * 按宽度等比例压缩图像
	 * @param imgSrc 待压缩图像路径
	 * @param distSrc 压缩后的图像保存路径
	 * @param distWidth 压缩后的宽度
	 * @throws Exception 
	 */
	public static void resizeWidth(String imgSrc, String distSrc, int distWidth) throws Exception{
		resize(imgSrc, distSrc, distWidth, null, false);
	}
	
	/**
	 * 按高度等比例压缩图像
	 * @param imgSrc 待压缩图像路径
	 * @param distSrc 压缩后的图像保存路径
	 * @param distHeight 压缩后的高度
	 * @throws Exception 
	 */
	public static void resizeHeight(String imgSrc, String distSrc, int distHeight) throws Exception{
		resize(imgSrc, distSrc, null, distHeight, false);
	}
	
	public static void main(String[] args) {
		try {
			//resizeWidth("D:/imgResize/a.jpg", "D:/imgResize/a_w_300.jpg", 300);
			//resize("D:/imgResize/a.jpg", "D:/imgResize/a_w_800.jpg", 300, 200, false);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
