package itez.kit;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EFile {

	public static boolean existInRes(String filePath) {
		if(filePath.startsWith("/")) filePath = filePath.substring(1);
		return existInJar(String.format("META-INF/resources/%s", filePath));
	}

	public static boolean existInJar(String filePath) {
		URL url = getClassLoader().getResource(filePath);
		return url != null;
	}

	public static String readInRes(String filePath) {
		if(filePath.startsWith("/")) filePath = filePath.substring(1);
		return readInJar(String.format("META-INF/resources/%s", filePath));
	}

	public static String readInJar(String filePath) {
		InputStream sm = getClassLoader().getResourceAsStream(filePath);
		return read(sm);
	}
	
	public static ClassLoader getClassLoader() {
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		return loader != null ? loader : EFile.class.getClassLoader();
	}
	
	public static String read(String filePath) {
		File file = new File(filePath);
		return read(file);
	}

	public static String read(File file) {
		ByteArrayOutputStream baos = null;
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(file);
			return read(fis);
		} catch (Exception e) {
		} finally {
			close(fis, baos);
		}
		return null;
	}

	public static String read(InputStream fis) {
		ByteArrayOutputStream baos = null;
		try {
			baos = new ByteArrayOutputStream();
			byte[] buffer = new byte[1024];
			for (int len = 0; (len = fis.read(buffer)) > 0;) {
				baos.write(buffer, 0, len);
			}
			return new String(baos.toByteArray(), EStr.Encoding);
		} catch (Exception e) {
		} finally {
			close(fis, baos);
		}
		return null;
	}

	public static void write(File file, String string) {
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(file, false);
			fos.write(string.getBytes(EStr.Encoding));
		} catch (Exception e) {
		} finally {
			close(null, fos);
		}
	}

	public static void write(File file, byte[] bytes) {
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(file, false);
			fos.write(bytes);
		} catch (Exception e) {
		} finally {
			close(null, fos);
		}
	}

	private static void close(InputStream is, OutputStream os) {
		if (is != null){
			try {
				is.close();
			} catch (IOException e) {}
		}
		if (os != null){
			try {
				os.close();
			} catch (IOException e) {}
		}
	}

	public static void unzip(String zipFilePath) throws IOException {
		String targetPath = zipFilePath.substring(0, zipFilePath.lastIndexOf("."));
		unzip(zipFilePath, targetPath);
	}

	public static void unzip(String zipFilePath, String targetPath) throws IOException {
		ZipFile zipFile = new ZipFile(zipFilePath);
		try {
			Enumeration<?> entryEnum = zipFile.entries();
			if (null != entryEnum) {
				while (entryEnum.hasMoreElements()) {
					OutputStream os = null;
					InputStream is = null;
					try {
						ZipEntry zipEntry = (ZipEntry) entryEnum.nextElement();
						if (!zipEntry.isDirectory()) {
							File targetFile = new File(targetPath + File.separator + zipEntry.getName());
							if (!targetFile.getParentFile().exists()) {
								targetFile.getParentFile().mkdirs();
							}
							os = new BufferedOutputStream(new FileOutputStream(targetFile));
							is = zipFile.getInputStream(zipEntry);
							byte[] buffer = new byte[4096];
							int readLen = 0;
							while ((readLen = is.read(buffer, 0, 4096)) > 0) {
								os.write(buffer, 0, readLen);
							}
						}
					} finally {
						if (is != null)
							is.close();
						if (os != null)
							os.close();
					}
				}
			}
		} finally {
			zipFile.close();
		}
	}
}
