package itez.kit;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * 用于获取指定包名下的所有类名
 * 并可设置是否遍历该包名下的子包的类名
 * 并可通过Annotation(内注)来过滤，避免一些内部类的干扰
 * 
 * @author Sodino E-mail:sodino@qq.com
 * @version Time：2014年2月10日 下午3:55:59
 */
public class EClassSearch {
	
	public static void main(String []args){
//		// 标识是否要遍历该包路径下子包的类名
//		boolean child = true;
//		// 指定的包名
//		String pkg = "itez.plat";
//		Set<Class<?>> list = null;
//		list = getClassList(pkg, child, CnpController.class, IController.class);
//		
//		for(Class<?> clazz : list){
//			System.out.println(clazz.getName());
//		}
	}
	
	/**
	 * 类扫描器
	 * 
	 * @param packageName 包名
	 * @param includeChild 是否包含子包
	 * @param annoClazz 注释类
	 * @return
	 */
	public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<? extends Annotation> annoClazz) {
		return getClassList(packageName, includeChild, null, annoClazz, null);
	}
	
	/**
	 * 类扫描器
	 * 
	 * @param packageName 包名
	 * @param includeChild 是否包含子包
	 * @param supperClazz 父类
	 * @param annoClazz 注释类
	 * @return
	 */
	public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz) {
		return getClassList(packageName, includeChild, supperClazz, annoClazz, null);
	}
	
	/**
	 * 类扫描器
	 * 
	 * @param packageName 包名
	 * @param includeChild 是否包含子包
	 * @param supperClazz 父类
	 * @param annoClazz 注释类
	 * @param skipPackage 忽略的包
	 * @return
	 */
	public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) {
		Set<Class<?>> clazzList = new HashSet<Class<?>>();
		ClassLoader loader = EFile.getClassLoader();
		try {
			String strFile = packageName.replaceAll("\\.", "/");
			Enumeration<URL> urls = loader.getResources(strFile);
			while (urls.hasMoreElements()) {
				URL url = urls.nextElement();
                if (url != null) {
                	String type = url.getProtocol();
                	String pkgPath = url.getPath();
                    if ("file".equals(type)) {
                    	findClassByFile(clazzList, packageName, pkgPath, includeChild, supperClazz, annoClazz, skipPackage);
					}else if ("jar".equals(type)) {
						findClassByJar(clazzList, packageName, url, includeChild, supperClazz, annoClazz, skipPackage);
                    }
                }
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return clazzList;
	}
	
	public static void findClassByFile(Set<Class<?>> clazzList, String packageName, String packagePath, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) {
		if(clazzList == null) return;
		File[] files = filterClassFiles(packagePath);// 过滤出.class文件及文件夹
		if(files != null){
			for (File f : files) {
				String fileName = f.getName();
				String filePath = f.getPath();
				if(skipPackage != null && skipPackage.stream().filter(s -> filePath.indexOf(s.replace(".", File.separator)) >= 0).count() > 0) continue;
				if (f.isFile()) {
					String clazzName = getClassName(packageName, fileName);
					addClassName(clazzList, clazzName, supperClazz, annoClazz);
				} else if(includeChild){
					String subPackageName = packageName +"."+ fileName;
					String subPackagePath = packagePath +"/"+ fileName;
					findClassByFile(clazzList, subPackageName, subPackagePath, true, supperClazz, annoClazz, skipPackage);
				}
			}
		}
	}
	
	public static void findClassByJar(Set<Class<?>> clazzList, String packageName, URL url, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) throws IOException {
		JarURLConnection jarURLConnection = (JarURLConnection) url.openConnection();
		JarFile jarFile = jarURLConnection.getJarFile();
		Enumeration<JarEntry> jarEntries = jarFile.entries();
		String packagePath = packageName.replace(".", "/");
		while (jarEntries.hasMoreElements()) {
			JarEntry jarEntry = jarEntries.nextElement();
			String jarEntryName = jarEntry.getName();
			if(!jarEntryName.startsWith(packagePath)) continue;
			if(!jarEntryName.endsWith(".class")) continue;
			if(skipPackage != null && skipPackage.stream().filter(s -> jarEntryName.replace("/", ".").startsWith(s)).count() > 0) continue;
			String clazzName = jarEntryName.replace("/", ".");
			int endIndex = clazzName.lastIndexOf(".");
			String prefix = null;
			if (endIndex > 0) {
				String prefix_name = clazzName.substring(0, endIndex);
				endIndex = prefix_name.lastIndexOf(".");
				if(endIndex > 0){
					prefix = prefix_name.substring(0, endIndex);
					clazzName = prefix_name.substring(endIndex);
				}
			}
			if (prefix != null) {
				clazzName = prefix + clazzName;
				if(prefix.equals(packageName)){
					addClassName(clazzList, clazzName, supperClazz, annoClazz);
				} else if(includeChild && prefix.startsWith(packageName)){
					addClassName(clazzList, clazzName, supperClazz, annoClazz);
				}
			}
		}
	}
	
	/**
	 * 筛选指定包路径下的.class文件以及子包
	 * @param pkgPath
	 * @return
	 */
	private static File[] filterClassFiles(String packagePath) {
		if(packagePath == null) return null;
		return new File(packagePath).listFiles(new FileFilter() {
			public boolean accept(File file) {
				return (file.isFile() && file.getName().endsWith(".class")) || file.isDirectory();
			}
		});
    }
	
	private static String getClassName(String packageName, String fileName) {
		int endIndex = fileName.lastIndexOf(".");
		String clazz = null;
		if (endIndex >= 0) {
			clazz = fileName.substring(0, endIndex);
		}
		String clazzName = null;
		if (clazz != null) {
			clazzName = packageName + "." + clazz;
		}
		return clazzName;
	}
	
	private static void addClassName(Set<Class<?>> clazzList, String clazzName, Class<?> supperClazz, Class<? extends Annotation> annoClazz) {
		if (clazzList != null && clazzName != null) {
			Class<?> clazz = EClass.loadClass(clazzName);			
			if (clazz != null) {
				if(supperClazz != null && !supperClazz.isAssignableFrom(clazz)) return;
				if(annoClazz != null && !clazz.isAnnotationPresent(annoClazz)) return;
				clazzList.add(clazz);
			}
		}
	}
}